/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.document;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.DocumentId;
import com.yahoo.document.json.DocumentOperationType;
import com.yahoo.document.json.readers.DocumentParseInfo;
import java.io.IOException;
import java.util.Optional;

public class DocumentParser {
    private static final String UPDATE = "update";
    private static final String PUT = "put";
    private static final String ID = "id";
    private static final String CONDITION = "condition";
    public static final String CREATE_IF_NON_EXISTENT = "create";
    public static final String FIELDS = "fields";
    public static final String REMOVE = "remove";
    private final JsonParser parser;
    private long indentLevel;

    public DocumentParser(JsonParser parser) {
        this.parser = parser;
    }

    public Optional<DocumentParseInfo> parse(Optional<DocumentId> documentIdArg) throws IOException {
        this.indentLevel = 0L;
        DocumentParseInfo documentParseInfo = new DocumentParseInfo();
        documentIdArg.ifPresent(documentId -> {
            documentParseInfo.documentId = documentId;
        });
        boolean foundItems = false;
        do {
            foundItems |= this.parseOneItem(documentParseInfo, documentIdArg.isPresent());
        } while (this.indentLevel > 0L);
        if (documentParseInfo.documentId == null) {
            if (foundItems) {
                throw new IllegalArgumentException("Missing a document operation ('put', 'update' or 'remove')");
            }
            return Optional.empty();
        }
        return Optional.of(documentParseInfo);
    }

    private boolean parseOneItem(DocumentParseInfo documentParseInfo, boolean docIdAndOperationIsSetExternally) throws IOException {
        this.parser.nextValue();
        this.processIndent();
        if (this.parser.getCurrentName() == null) {
            return false;
        }
        if (this.indentLevel == 1L) {
            this.handleIdentLevelOne(documentParseInfo, docIdAndOperationIsSetExternally);
        } else if (this.indentLevel == 2L) {
            this.handleIdentLevelTwo(documentParseInfo);
        }
        return true;
    }

    private void processIndent() {
        JsonToken currentToken = this.parser.currentToken();
        if (currentToken == null) {
            throw new IllegalArgumentException("Could not read document, no document?");
        }
        switch (currentToken) {
            case START_OBJECT: {
                ++this.indentLevel;
                break;
            }
            case END_OBJECT: {
                --this.indentLevel;
                break;
            }
            case START_ARRAY: {
                this.indentLevel += 10000L;
                break;
            }
            case END_ARRAY: {
                this.indentLevel -= 10000L;
            }
        }
    }

    private void handleIdentLevelOne(DocumentParseInfo documentParseInfo, boolean docIdAndOperationIsSetExternally) throws IOException {
        JsonToken currentToken = this.parser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_TRUE || currentToken == JsonToken.VALUE_FALSE) {
            try {
                if (CREATE_IF_NON_EXISTENT.equals(this.parser.getCurrentName())) {
                    documentParseInfo.create = Optional.ofNullable(this.parser.getBooleanValue());
                    return;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Got IO exception while parsing document", e);
            }
        }
        if ((currentToken == JsonToken.VALUE_TRUE || currentToken == JsonToken.VALUE_FALSE) && CREATE_IF_NON_EXISTENT.equals(this.parser.getCurrentName())) {
            documentParseInfo.create = Optional.of(currentToken == JsonToken.VALUE_TRUE);
        } else if (currentToken == JsonToken.VALUE_STRING && CONDITION.equals(this.parser.getCurrentName())) {
            documentParseInfo.condition = Optional.of(this.parser.getText());
        } else if (currentToken == JsonToken.VALUE_STRING && !docIdAndOperationIsSetExternally) {
            documentParseInfo.operationType = DocumentParser.operationNameToOperationType(this.parser.getCurrentName());
            documentParseInfo.documentId = new DocumentId(this.parser.getText());
        }
    }

    private void handleIdentLevelTwo(DocumentParseInfo documentParseInfo) {
        try {
            JsonToken currentToken = this.parser.getCurrentToken();
            if (currentToken == JsonToken.START_OBJECT && FIELDS.equals(this.parser.getCurrentName())) {
                documentParseInfo.fieldsBuffer.bufferObject(currentToken, this.parser);
                this.processIndent();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Got IO exception while parsing document", e);
        }
    }

    private static DocumentOperationType operationNameToOperationType(String operationName) {
        return switch (operationName) {
            case PUT, ID -> DocumentOperationType.PUT;
            case REMOVE -> DocumentOperationType.REMOVE;
            case UPDATE -> DocumentOperationType.UPDATE;
            default -> throw new IllegalArgumentException("Got " + operationName + " as document operation, only \"put\", \"remove\" and \"update\" are supported.");
        };
    }
}

