/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.ArrayReader;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.MapReader;
import com.yahoo.document.json.readers.StructReader;
import com.yahoo.document.json.readers.TensorReader;
import com.yahoo.document.json.readers.WeightedSetReader;

public class CompositeReader {
    public static void populateComposite(TokenBuffer buffer, FieldValue fieldValue) {
        JsonToken token = buffer.currentToken();
        if (token != JsonToken.START_OBJECT && token != JsonToken.START_ARRAY) {
            throw new IllegalArgumentException("Expected '[' or '{'. Got '" + token + "'.");
        }
        if (fieldValue instanceof CollectionFieldValue) {
            DataType valueType = ((CollectionFieldValue)fieldValue).getDataType().getNestedType();
            if (fieldValue instanceof WeightedSet) {
                WeightedSetReader.fillWeightedSet(buffer, valueType, (WeightedSet)fieldValue);
            } else {
                ArrayReader.fillArray(buffer, (CollectionFieldValue)fieldValue, valueType);
            }
        } else if (fieldValue instanceof MapFieldValue) {
            MapReader.fillMap(buffer, (MapFieldValue)fieldValue);
        } else if (fieldValue instanceof StructuredFieldValue) {
            StructReader.fillStruct(buffer, (StructuredFieldValue)fieldValue);
        } else if (fieldValue instanceof TensorFieldValue) {
            TensorReader.fillTensor(buffer, (TensorFieldValue)fieldValue);
        } else {
            throw new IllegalStateException("Has created a composite field value the reader does not know how to handle: " + fieldValue.getClass().getName() + " This is a bug. token = " + token);
        }
        JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
    }
}

