/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.GlobalId;
import com.yahoo.document.idstring.IdString;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.document.serialization.DocumentReader;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.document.serialization.SerializationException;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.Serializer;
import java.io.Serializable;
import java.util.Objects;

public class DocumentId
extends Identifiable
implements Serializable {
    private IdString id;
    private GlobalId globalId = null;

    public DocumentId(Deserializer buf) {
        this.deserialize(buf);
    }

    public DocumentId(String id) {
        this.id = IdString.createIdString(Objects.requireNonNull(id));
        if (id.length() > 65536) {
            throw new IllegalArgumentException("Document id of length " + id.length() + " is longer than the max 65536");
        }
    }

    public DocumentId(IdString id) {
        this.id = id;
    }

    public static DocumentId createFromSerialized(String id) {
        return new DocumentId(IdString.createFromSerialized(id));
    }

    public DocumentId clone() {
        return (DocumentId)super.clone();
    }

    public void setId(IdString id) {
        this.id = id;
    }

    public IdString getScheme() {
        return this.id;
    }

    public byte[] getGlobalId() {
        if (this.globalId == null) {
            this.globalId = new GlobalId(this.id);
        }
        return this.globalId.getRawId();
    }

    public int compareTo(Object o) {
        DocumentId cmp = (DocumentId)o;
        return this.id.toString().compareTo(cmp.id.toString());
    }

    public boolean equals(Object o) {
        return o instanceof DocumentId && this.id.equals(((DocumentId)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    public void onSerialize(Serializer target) throws SerializationException {
        if (target instanceof DocumentWriter) {
            ((DocumentWriter)target).write(this);
        } else {
            target.put(null, this.id.toString());
        }
    }

    public void onDeserialize(Deserializer data) throws DeserializationException {
        this.id = data instanceof DocumentReader ? ((DocumentReader)data).readDocumentId().getScheme() : IdString.createFromSerialized(data.getString(null));
    }

    public boolean hasDocType() {
        return this.id.hasDocType();
    }

    public String getDocType() {
        return this.id.getDocType();
    }
}

