/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.google.inject.Inject;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TemporaryDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.AnnotationTypeRegistry;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentDeserializerFactory;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.TensorType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DocumentTypeManager {
    private static final Logger log = Logger.getLogger(DocumentTypeManager.class.getName());
    private ConfigSubscriber subscriber;
    private Map<Integer, DataType> dataTypes = new LinkedHashMap<Integer, DataType>();
    private Map<DataTypeName, DocumentType> documentTypes = new LinkedHashMap<DataTypeName, DocumentType>();
    private AnnotationTypeRegistry annotationTypeRegistry = new AnnotationTypeRegistry();

    public DocumentTypeManager() {
        this.registerDefaultDataTypes();
    }

    @Inject
    public DocumentTypeManager(DocumentmanagerConfig config) {
        this();
        DocumentTypeManagerConfigurer.configureNewManager(config, this);
    }

    public void assign(DocumentTypeManager other) {
        this.dataTypes = other.dataTypes;
        this.documentTypes = other.documentTypes;
        this.annotationTypeRegistry = other.annotationTypeRegistry;
    }

    @Deprecated
    public DocumentTypeManager configure(String configId) {
        this.subscriber = DocumentTypeManagerConfigurer.configure(this, configId);
        return this;
    }

    public static DocumentTypeManager fromFile(String fileName) {
        DocumentTypeManager manager = new DocumentTypeManager();
        ConfigSubscriber sub = DocumentTypeManagerConfigurer.configure(manager, "file:" + fileName);
        sub.close();
        return manager;
    }

    private void registerDefaultDataTypes() {
        DocumentType superDocType = DataType.DOCUMENT;
        this.dataTypes.put(superDocType.getId(), superDocType);
        this.documentTypes.put(superDocType.getDataTypeName(), superDocType);
        Class<DataType> dataTypeClass = DataType.class;
        for (Field field : dataTypeClass.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !DataType.class.isAssignableFrom(field.getType())) continue;
            try {
                DataType type = (DataType)field.get(null);
                this.register(type);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (AnnotationType type : AnnotationTypes.ALL_TYPES) {
            this.annotationTypeRegistry.register(type);
        }
    }

    public boolean hasDataType(String name) {
        if (name.startsWith("tensor(")) {
            return true;
        }
        for (DataType type : this.dataTypes.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasDataType(int code) {
        if (code == 21) {
            return true;
        }
        return this.dataTypes.containsKey(code);
    }

    @Deprecated
    public DataType getDataType(String name) {
        return this.getDataTypeInternal(name);
    }

    DataType getDataTypeInternal(String name) {
        if (name.startsWith("tensor(")) {
            return new TensorDataType(TensorType.fromSpec((String)name));
        }
        ArrayList<DataType> foundTypes = new ArrayList<DataType>();
        for (DataType type : this.dataTypes.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            foundTypes.add(type);
        }
        if (foundTypes.isEmpty()) {
            throw new IllegalArgumentException("No datatype named " + name);
        }
        if (foundTypes.size() == 1) {
            return (DataType)foundTypes.get(0);
        }
        Collections.sort(foundTypes, new Comparator<DataType>(){

            @Override
            public int compare(DataType first, DataType second) {
                if (first instanceof StructuredDataType && !(second instanceof StructuredDataType)) {
                    return 1;
                }
                if (!(first instanceof StructuredDataType) && second instanceof StructuredDataType) {
                    return -1;
                }
                return 0;
            }
        });
        return (DataType)foundTypes.get(0);
    }

    @Deprecated
    public DataType getDataType(int code) {
        return this.getDataType(code, "");
    }

    @Deprecated
    public DataType getDataType(int code, String detailedType) {
        if (code == 21) {
            return new TensorDataType(TensorType.fromSpec((String)detailedType));
        }
        DataType type = this.dataTypes.get(code);
        if (type == null) {
            StringBuilder types = new StringBuilder();
            for (Integer key : this.dataTypes.keySet()) {
                types.append(key).append(" ");
            }
            throw new IllegalArgumentException("No datatype with code " + code + ". Registered type ids: " + types);
        }
        return type;
    }

    @Deprecated
    DataType getDataTypeAndReturnTemporary(int code, String detailedType) {
        if (this.hasDataType(code)) {
            return this.getDataType(code, detailedType);
        }
        return new TemporaryDataType(code, detailedType);
    }

    public void register(DataType type) {
        type.register(this);
    }

    void registerSingleType(DataType type) {
        if (type instanceof TensorDataType) {
            return;
        }
        if (type instanceof TemporaryDataType) {
            throw new IllegalArgumentException("TemporaryDataType no longer supported: " + type);
        }
        if (type instanceof TemporaryStructuredDataType) {
            throw new IllegalArgumentException("TemporaryStructuredDataType no longer supported: " + type);
        }
        if (this.dataTypes.containsKey(type.getId())) {
            DataType existingType = this.dataTypes.get(type.getId());
            if (existingType == type || existingType.equals(type)) {
                return;
            }
            throw new IllegalStateException("Datatype " + existingType + " is not equal to datatype attempted registered " + type + ", but already uses id " + type.getId());
        }
        if (type instanceof DocumentType) {
            DocumentType docType = (DocumentType)type;
            if (docType.getInheritedTypes().size() == 0) {
                docType.inherit(this.documentTypes.get(new DataTypeName("document")));
            }
            this.documentTypes.put(docType.getDataTypeName(), docType);
        }
        this.dataTypes.put(type.getId(), type);
        type.setRegistered();
    }

    public DocumentType registerDocumentType(DocumentType docType) {
        this.register(docType);
        return docType;
    }

    public DocumentType getDocumentType(DataTypeName name) {
        return this.documentTypes.get(name);
    }

    public DocumentType getDocumentType(String name) {
        return this.documentTypes.get(new DataTypeName(name));
    }

    public final Document createDocument(GrowableByteBuffer buf) {
        DocumentDeserializer data = DocumentDeserializerFactory.create6(this, buf);
        return new Document(data);
    }

    public Document createDocument(DocumentDeserializer data) {
        return new Document(data);
    }

    public Collection<DataType> getDataTypes() {
        return Collections.unmodifiableCollection(this.dataTypes.values());
    }

    public Map<DataTypeName, DocumentType> getDocumentTypes() {
        return Collections.unmodifiableMap(this.documentTypes);
    }

    public Iterator<DocumentType> documentTypeIterator() {
        return this.documentTypes.values().iterator();
    }

    @Deprecated
    public void clear() {
        this.documentTypes.clear();
        this.dataTypes.clear();
        this.registerDefaultDataTypes();
    }

    public AnnotationTypeRegistry getAnnotationTypeRegistry() {
        return this.annotationTypeRegistry;
    }

    @Deprecated
    public void shutdown() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

