/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.simple;

import com.yahoo.document.select.rule.LiteralNode;
import com.yahoo.document.select.simple.Parser;

public class IntegerParser
extends Parser {
    private LiteralNode value;

    public LiteralNode getValue() {
        return this.value;
    }

    @Override
    public boolean parse(CharSequence s) {
        boolean retval = false;
        int pos = this.eatWhite(s);
        if (pos < s.length()) {
            boolean isHex = s.length() - pos > 2 && s.charAt(pos) == '0' && s.charAt(pos + 1) == 'x';
            Long v = null;
            int startPos = pos;
            if (isHex) {
                startPos = pos + 2;
                while (pos < s.length() && (s.charAt(pos) >= '0' && s.charAt(pos) <= '9' || s.charAt(pos) >= 'a' && s.charAt(pos) <= 'f' || s.charAt(pos) >= 'A' && s.charAt(pos) <= 'F')) {
                    ++pos;
                }
                if (pos > startPos) {
                    v = Long.valueOf(s.subSequence(startPos, pos).toString(), 16);
                    retval = true;
                }
            } else {
                if (s.charAt(pos) == '-' || s.charAt(pos) == '+') {
                    ++pos;
                }
                while (pos < s.length() && s.charAt(pos) >= '0' && s.charAt(pos) <= '9') {
                    ++pos;
                }
                if (pos > startPos) {
                    v = Long.valueOf(s.subSequence(startPos, pos).toString(), 10);
                    retval = true;
                }
            }
            this.value = new LiteralNode(v);
        }
        this.setRemaining(s.subSequence(pos, s.length()));
        return retval;
    }
}

