/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.google.common.collect.ImmutableList;
import com.yahoo.document.BaseStructDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class StructDataType
extends BaseStructDataType {
    public static final int classId = StructDataType.registerClass((int)4153, StructDataType.class);
    private StructDataType superType = null;

    public StructDataType(String name) {
        super(name);
    }

    public StructDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public Struct createFieldValue() {
        return new Struct((DataType)this);
    }

    @Override
    public FieldValue createFieldValue(Object o) {
        Struct struct;
        if (o.getClass().equals(Struct.class)) {
            struct = new Struct((DataType)this);
        } else {
            try {
                struct = (Struct)o.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                struct = new Struct((DataType)this);
            }
        }
        struct.assign(o);
        return struct;
    }

    @Override
    public StructDataType clone() {
        StructDataType type = (StructDataType)super.clone();
        type.superType = this.superType;
        return type;
    }

    public void assign(StructDataType type) {
        super.assign(type);
        this.superType = type.superType;
    }

    @Override
    public Field getField(String fieldName) {
        Field f = super.getField(fieldName);
        if (f == null && this.superType != null) {
            f = this.superType.getField(fieldName);
        }
        return f;
    }

    @Override
    public Field getField(int id) {
        Field f = super.getField(id);
        if (f == null && this.superType != null) {
            f = this.superType.getField(id);
        }
        return f;
    }

    @Override
    public void addField(Field field) {
        if (this.hasField(field)) {
            throw new IllegalArgumentException("Struct already has field " + field);
        }
        if (this.superType != null && this.superType.hasField(field)) {
            throw new IllegalArgumentException(field.toString() + " already present in inherited type '" + this.superType.toString() + "', " + this.toString() + " cannot override.");
        }
        super.addField(field);
    }

    @Override
    public Collection<Field> getFields() {
        if (this.superType == null) {
            return Collections.unmodifiableCollection(super.getFields());
        }
        ArrayList<Field> fieldsBuilder = new ArrayList<Field>();
        fieldsBuilder.addAll(super.getFields());
        fieldsBuilder.addAll(this.superType.getFields());
        return ImmutableList.copyOf(fieldsBuilder);
    }

    public Collection<Field> getFieldsThisTypeOnly() {
        return Collections.unmodifiableCollection(super.getFields());
    }

    @Override
    public int getFieldCount() {
        return this.getFields().size();
    }

    @Override
    public Class getValueClass() {
        return Struct.class;
    }

    @Override
    public boolean isValueCompatible(FieldValue value) {
        if (!(value instanceof Struct)) {
            return false;
        }
        Struct structValue = (Struct)value;
        return structValue.getDataType().inherits(this);
    }

    public void inherit(StructDataType type) {
        if (this.superType != null) {
            throw new IllegalArgumentException("Already inherits type " + this.superType + ", multiple inheritance not currently supported.");
        }
        for (Field f : type.getFields()) {
            if (!this.hasField(f)) continue;
            throw new IllegalArgumentException(f + " already present in " + type + ", " + this + " cannot inherit from it");
        }
        this.superType = type;
    }

    public Collection<StructDataType> getInheritedTypes() {
        if (this.superType == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.superType);
    }

    public boolean inherits(StructDataType type) {
        if (this.equals(type)) {
            return true;
        }
        return this.superType != null && this.superType.inherits(type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructDataType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructDataType that = (StructDataType)o;
        return !(this.superType != null ? !this.superType.equals(that.superType) : that.superType != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.superType != null ? this.superType.hashCode() : 0);
        return result;
    }
}

