/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public class TensorReader {
    public static final String TENSOR_ADDRESS = "address";
    public static final String TENSOR_DIMENSIONS = "dimensions";
    public static final String TENSOR_CELLS = "cells";
    public static final String TENSOR_VALUE = "value";

    public static void fillTensor(TokenBuffer buffer, TensorFieldValue tensorFieldValue) {
        Tensor.Builder tensorBuilder = Tensor.Builder.of((TensorType)tensorFieldValue.getDataType().getTensorType());
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            if (TENSOR_CELLS.equals(buffer.currentName())) {
                TensorReader.readTensorCells(buffer, tensorBuilder);
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        tensorFieldValue.assign(tensorBuilder.build());
    }

    public static void readTensorCells(TokenBuffer buffer, Tensor.Builder tensorBuilder) {
        JsonParserHelpers.expectArrayStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            TensorReader.readTensorCell(buffer, tensorBuilder);
            buffer.next();
        }
        JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
    }

    public static void readTensorCell(TokenBuffer buffer, Tensor.Builder tensorBuilder) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        double cellValue = 0.0;
        Tensor.Builder.CellBuilder cellBuilder = tensorBuilder.cell();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String currentName = buffer.currentName();
            if (TENSOR_ADDRESS.equals(currentName)) {
                TensorReader.readTensorAddress(buffer, cellBuilder);
            } else if (TENSOR_VALUE.equals(currentName)) {
                cellValue = Double.valueOf(buffer.currentText());
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        cellBuilder.value(cellValue);
    }

    public static void readTensorAddress(TokenBuffer buffer, Tensor.Builder.CellBuilder cellBuilder) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String dimension = buffer.currentName();
            String label = buffer.currentText();
            cellBuilder.label(dimension, label);
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
    }
}

