/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaxmlparser;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.VespaXMLDocumentReader;
import com.yahoo.vespaxmlparser.VespaXMLReader;
import com.yahoo.vespaxmlparser.VespaXMLUpdateReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class VespaXMLFeedReader
extends VespaXMLReader
implements FeedReader {
    public VespaXMLFeedReader(String fileName, DocumentTypeManager docTypeManager) throws Exception {
        super(fileName, docTypeManager);
        this.readInitial();
    }

    public VespaXMLFeedReader(InputStream stream, DocumentTypeManager docTypeManager) throws Exception {
        super(stream, docTypeManager);
        this.readInitial();
    }

    public VespaXMLFeedReader(XMLStreamReader reader, DocumentTypeManager manager) throws Exception {
        super(reader, manager);
        this.readInitial();
    }

    void readInitial() throws Exception {
        boolean found = false;
        while (this.reader.hasNext()) {
            int type = this.reader.next();
            if (type != 1 || !"vespafeed".equals(this.reader.getName().toString())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw this.newDeserializeException("Feed information must be contained within a \"vespafeed\" element");
        }
    }

    public List<Operation> readAll() throws Exception {
        ArrayList<Operation> list = new ArrayList<Operation>();
        while (true) {
            Operation op = new Operation();
            this.read(op);
            if (op.getType() == OperationType.INVALID) {
                return list;
            }
            list.add(op);
        }
    }

    @Override
    public void read(Operation operation) throws Exception {
        String startTag = null;
        operation.setInvalid();
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type != 1) continue;
                startTag = this.reader.getName().toString();
                if ("document".equals(startTag)) {
                    VespaXMLDocumentReader documentReader = new VespaXMLDocumentReader(this.reader, this.docTypeManager);
                    Document document = new Document(documentReader);
                    operation.setDocument(document);
                    operation.setCondition(TestAndSetCondition.fromConditionString(documentReader.getCondition()));
                    return;
                }
                if ("update".equals(startTag)) {
                    VespaXMLUpdateReader updateReader = new VespaXMLUpdateReader(this.reader, this.docTypeManager);
                    DocumentUpdate update = new DocumentUpdate(updateReader);
                    operation.setDocumentUpdate(update);
                    operation.setCondition(TestAndSetCondition.fromConditionString(updateReader.getCondition()));
                    return;
                }
                if ("remove".equals(startTag)) {
                    boolean documentIdFound = false;
                    Optional<String> condition = Optional.empty();
                    for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                        String attributeName = this.reader.getAttributeName(i).toString();
                        if ("documentid".equals(attributeName) || "id".equals(attributeName)) {
                            operation.setRemove(new DocumentId(this.reader.getAttributeValue(i)));
                            documentIdFound = true;
                            continue;
                        }
                        if (!"condition".equals(attributeName)) continue;
                        condition = Optional.of(this.reader.getAttributeValue(i));
                    }
                    if (!documentIdFound) {
                        throw this.newDeserializeException("Missing \"documentid\" attribute for remove operation");
                    }
                    operation.setCondition(TestAndSetCondition.fromConditionString(condition));
                    return;
                }
                throw this.newDeserializeException("Element \"" + startTag + "\" not allowed in this context");
            }
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (startTag != null) {
                    this.skipToEnd(startTag);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public void read(FeedOperation fo) throws XMLStreamException {
        while (this.reader.hasNext()) {
            int type = this.reader.next();
            if (type == 1) {
                if ("name".equals(this.reader.getName().toString())) {
                    fo.setName(this.reader.getElementText().toString());
                    this.skipToEnd("name");
                    continue;
                }
                if ("generation".equals(this.reader.getName().toString())) {
                    fo.setGeneration(Integer.parseInt(this.reader.getElementText().toString()));
                    this.skipToEnd("generation");
                    continue;
                }
                if (!"increment".equals(this.reader.getName().toString())) continue;
                String text = this.reader.getElementText();
                if ("autodetect".equals(text)) {
                    fo.setIncrement(-1);
                } else {
                    fo.setIncrement(Integer.parseInt(text));
                }
                this.skipToEnd("increment");
                continue;
            }
            if (type != 2) continue;
            return;
        }
    }

    public static class FeedOperation {
        private String name;
        private Integer generation;
        private Integer increment;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getGeneration() {
            return this.generation;
        }

        public void setGeneration(int generation) {
            this.generation = generation;
        }

        public Integer getIncrement() {
            return this.increment;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }
    }

    public static class Operation {
        private OperationType type;
        private Document doc;
        private DocumentId remove;
        private DocumentUpdate docUpdate;
        private FeedOperation feedOperation;
        private TestAndSetCondition condition;

        public Operation() {
            this.setInvalid();
        }

        public void setInvalid() {
            this.type = OperationType.INVALID;
            this.doc = null;
            this.remove = null;
            this.docUpdate = null;
            this.feedOperation = null;
            this.condition = null;
        }

        public OperationType getType() {
            return this.type;
        }

        public Document getDocument() {
            return this.doc;
        }

        public void setDocument(Document doc) {
            this.type = OperationType.DOCUMENT;
            this.doc = doc;
        }

        public DocumentId getRemove() {
            return this.remove;
        }

        public void setRemove(DocumentId remove) {
            this.type = OperationType.REMOVE;
            this.remove = remove;
        }

        public DocumentUpdate getDocumentUpdate() {
            return this.docUpdate;
        }

        public void setDocumentUpdate(DocumentUpdate docUpdate) {
            this.type = OperationType.UPDATE;
            this.docUpdate = docUpdate;
        }

        public FeedOperation getFeedOperation() {
            return this.feedOperation;
        }

        public void setCondition(TestAndSetCondition condition) {
            this.condition = condition;
        }

        public TestAndSetCondition getCondition() {
            return this.condition;
        }

        public String toString() {
            return "Operation{type=" + this.type + ", doc=" + this.doc + ", remove=" + this.remove + ", docUpdate=" + this.docUpdate + ", feedOperation=" + this.feedOperation + "}";
        }
    }

    public static enum OperationType {
        DOCUMENT,
        REMOVE,
        UPDATE,
        INVALID;

    }
}

