/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentId;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.CompositeReader;
import com.yahoo.document.update.ValueUpdate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class SingleValueReader {
    public static final String UPDATE_ASSIGN = "assign";
    public static final String UPDATE_INCREMENT = "increment";
    public static final String UPDATE_DECREMENT = "decrement";
    public static final String UPDATE_MULTIPLY = "multiply";
    public static final String UPDATE_DIVIDE = "divide";
    public static final Map<String, String> UPDATE_OPERATION_TO_ARITHMETIC_SIGN = new HashMap<String, String>();
    public static final Map<String, String> ARITHMETIC_SIGN_TO_UPDATE_OPERATION;
    private static final Pattern arithmeticExpressionPattern;

    public static FieldValue readSingleValue(TokenBuffer buffer, DataType expectedType) {
        if (buffer.currentToken().isScalarValue()) {
            return SingleValueReader.readAtomic(buffer.currentText(), expectedType);
        }
        FieldValue fieldValue = expectedType.createFieldValue();
        CompositeReader.populateComposite(buffer, fieldValue);
        return fieldValue;
    }

    public static ValueUpdate readSingleUpdate(TokenBuffer buffer, DataType expectedType, String action) {
        ValueUpdate update;
        switch (action) {
            case "assign": {
                update = buffer.currentToken() == JsonToken.VALUE_NULL ? ValueUpdate.createClear() : ValueUpdate.createAssign(SingleValueReader.readSingleValue(buffer, expectedType));
                break;
            }
            case "increment": {
                update = ValueUpdate.createIncrement(Double.valueOf(buffer.currentText()));
                break;
            }
            case "decrement": {
                update = ValueUpdate.createDecrement(Double.valueOf(buffer.currentText()));
                break;
            }
            case "multiply": {
                update = ValueUpdate.createMultiply(Double.valueOf(buffer.currentText()));
                break;
            }
            case "divide": {
                update = ValueUpdate.createDivide(Double.valueOf(buffer.currentText()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation '" + buffer.currentName() + "' not implemented.");
            }
        }
        return update;
    }

    public static Matcher matchArithmeticOperation(String expression) {
        return arithmeticExpressionPattern.matcher(expression.trim());
    }

    public static FieldValue readAtomic(String field, DataType expectedType) {
        if (expectedType.equals(DataType.RAW)) {
            return expectedType.createFieldValue(new Base64().decode(field));
        }
        if (expectedType.equals(PositionDataType.INSTANCE)) {
            return PositionDataType.fromString(field);
        }
        if (expectedType instanceof ReferenceDataType) {
            return SingleValueReader.readReferenceFieldValue(field, expectedType);
        }
        return expectedType.createFieldValue(field);
    }

    private static FieldValue readReferenceFieldValue(String refText, DataType expectedType) {
        FieldValue value = expectedType.createFieldValue();
        if (!refText.isEmpty()) {
            value.assign(new DocumentId(refText));
        }
        return value;
    }

    static {
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_INCREMENT, "+");
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_DECREMENT, "-");
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_MULTIPLY, "*");
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_DIVIDE, "/");
        ARITHMETIC_SIGN_TO_UPDATE_OPERATION = UPDATE_OPERATION_TO_ARITHMETIC_SIGN.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        String validSigns = Pattern.quote(String.join((CharSequence)"", UPDATE_OPERATION_TO_ARITHMETIC_SIGN.values()));
        arithmeticExpressionPattern = Pattern.compile("^\\$\\w+\\s*([" + validSigns + "])\\s*(\\d+(.\\d+)?)$");
    }
}

