/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.TensorReader;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.Iterator;

public class TensorModifyUpdateReader {
    public static final String UPDATE_MODIFY = "modify";
    private static final String MODIFY_OPERATION = "operation";
    private static final String MODIFY_REPLACE = "replace";
    private static final String MODIFY_ADD = "add";
    private static final String MODIFY_MULTIPLY = "multiply";

    public static TensorModifyUpdate createModifyUpdate(TokenBuffer buffer, Field field) {
        TensorModifyUpdateReader.expectFieldIsOfTypeTensor(field);
        TensorModifyUpdateReader.expectTensorTypeHasNoneIndexedUnboundDimensions(field);
        TensorModifyUpdateReader.expectTensorTypeIsNotMixed(field);
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        ModifyUpdateResult result = TensorModifyUpdateReader.createModifyUpdateResult(buffer, field);
        TensorModifyUpdateReader.expectOperationSpecified(result.operation, field.getName());
        TensorModifyUpdateReader.expectTensorSpecified(result.tensor, field.getName());
        return new TensorModifyUpdate(result.operation, result.tensor);
    }

    private static void expectFieldIsOfTypeTensor(Field field) {
        if (!(field.getDataType() instanceof TensorDataType)) {
            throw new IllegalArgumentException("A modify update can only be applied to tensor fields. Field '" + field.getName() + "' is of type '" + field.getDataType().getName() + "'");
        }
    }

    private static void expectTensorTypeHasNoneIndexedUnboundDimensions(Field field) {
        TensorType tensorType = ((TensorDataType)field.getDataType()).getTensorType();
        if (tensorType.dimensions().stream().anyMatch(dim -> dim.type().equals((Object)TensorType.Dimension.Type.indexedUnbound))) {
            throw new IllegalArgumentException("A modify update cannot be applied to tensor types with indexed unbound dimensions. Field '" + field.getName() + "' has unsupported tensor type '" + tensorType + "'");
        }
    }

    private static void expectTensorTypeIsNotMixed(Field field) {
        TensorType tensorType = ((TensorDataType)field.getDataType()).getTensorType();
        long numMappedDimensions = tensorType.dimensions().stream().filter(dim -> dim.type().equals((Object)TensorType.Dimension.Type.mapped)).count();
        long numIndexedDimensions = tensorType.dimensions().stream().filter(dim -> dim.isIndexed()).count();
        if (numMappedDimensions > 0L && numIndexedDimensions > 0L) {
            throw new IllegalArgumentException("A modify update cannot be applied to tensor types with mixed dimensions. Field '" + field.getName() + "' has mixed tensor type '" + tensorType + "'");
        }
    }

    private static void expectOperationSpecified(TensorModifyUpdate.Operation operation, String fieldName) {
        if (operation == null) {
            throw new IllegalArgumentException("Modify update for field '" + fieldName + "' does not contain an operation");
        }
    }

    private static void expectTensorSpecified(TensorFieldValue tensor, String fieldName) {
        if (tensor == null) {
            throw new IllegalArgumentException("Modify update for field '" + fieldName + "' does not contain tensor cells");
        }
    }

    private static ModifyUpdateResult createModifyUpdateResult(TokenBuffer buffer, Field field) {
        ModifyUpdateResult result = new ModifyUpdateResult();
        buffer.next();
        int localNesting = buffer.nesting();
        while (localNesting <= buffer.nesting()) {
            switch (buffer.currentName()) {
                case "operation": {
                    result.operation = TensorModifyUpdateReader.createOperation(buffer, field.getName());
                    break;
                }
                case "cells": {
                    result.tensor = TensorModifyUpdateReader.createTensor(buffer, field);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown JSON string '" + buffer.currentName() + "' in modify update for field '" + field.getName() + "'");
                }
            }
            buffer.next();
        }
        return result;
    }

    private static TensorModifyUpdate.Operation createOperation(TokenBuffer buffer, String fieldName) {
        switch (buffer.currentText()) {
            case "replace": {
                return TensorModifyUpdate.Operation.REPLACE;
            }
            case "add": {
                return TensorModifyUpdate.Operation.ADD;
            }
            case "multiply": {
                return TensorModifyUpdate.Operation.MULTIPLY;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + buffer.currentText() + "' in modify update for field '" + fieldName + "'");
    }

    private static TensorFieldValue createTensor(TokenBuffer buffer, Field field) {
        TensorDataType tensorDataType = (TensorDataType)field.getDataType();
        TensorType originalType = tensorDataType.getTensorType();
        TensorType convertedType = TensorModifyUpdate.convertToCompatibleType(originalType);
        Tensor.Builder tensorBuilder = Tensor.Builder.of((TensorType)convertedType);
        TensorReader.readTensorCells(buffer, tensorBuilder);
        Tensor tensor = tensorBuilder.build();
        TensorModifyUpdateReader.validateBounds(tensor, originalType);
        TensorFieldValue result = new TensorFieldValue(convertedType);
        result.assign(tensor);
        return result;
    }

    private static void validateBounds(Tensor convertedTensor, TensorType originalType) {
        if (!originalType.dimensions().stream().allMatch(d -> d instanceof TensorType.IndexedBoundDimension)) {
            return;
        }
        Iterator iter = convertedTensor.cellIterator();
        while (iter.hasNext()) {
            Tensor.Cell cell = (Tensor.Cell)iter.next();
            TensorAddress address = cell.getKey();
            for (int i = 0; i < address.size(); ++i) {
                long bound;
                long label = address.numericLabel(i);
                if (label < (bound = ((Long)((TensorType.Dimension)originalType.dimensions().get(i)).size().get()).longValue())) continue;
                throw new IndexOutOfBoundsException("Dimension '" + ((TensorType.Dimension)originalType.dimensions().get(i)).name() + "' has label '" + label + "' but type is " + originalType.toString());
            }
        }
    }

    private static class ModifyUpdateResult {
        TensorModifyUpdate.Operation operation = null;
        TensorFieldValue tensor = null;

        private ModifyUpdateResult() {
        }
    }
}

