/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select;

import java.util.Objects;

public class OrderingSpecification {
    public static int ASCENDING = 0;
    public static int DESCENDING = 1;
    public final int order;
    public final long orderingStart;
    public final short widthBits;
    public final short divisionBits;

    public OrderingSpecification() {
        this(ASCENDING, 0L, 0, 0);
    }

    public OrderingSpecification(int order) {
        this(order, 0L, 0, 0);
    }

    public OrderingSpecification(int order, long orderingStart, short widthBits, short divisionBits) {
        this.order = order;
        this.orderingStart = orderingStart;
        this.widthBits = widthBits;
        this.divisionBits = divisionBits;
    }

    public int getOrder() {
        return this.order;
    }

    public long getOrderingStart() {
        return this.orderingStart;
    }

    public short getWidthBits() {
        return this.widthBits;
    }

    public short getDivisionBits() {
        return this.divisionBits;
    }

    public boolean equals(Object other) {
        OrderingSpecification o = (OrderingSpecification)other;
        if (o == null) {
            return false;
        }
        return this.order == o.order && this.orderingStart == o.orderingStart && this.widthBits == o.widthBits && this.divisionBits == o.divisionBits;
    }

    public int hashCode() {
        return Objects.hash(this.order, this.orderingStart, this.widthBits, this.divisionBits);
    }

    public String toString() {
        return "O: " + this.order + " S:" + this.orderingStart + " W:" + this.widthBits + " D:" + this.divisionBits;
    }
}

