/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.FieldPath;
import com.yahoo.document.FieldPathEntry;
import com.yahoo.document.datatypes.Array;
import java.util.ArrayList;

public class ArrayDataType
extends CollectionDataType {
    public static int classId = ArrayDataType.registerClass((int)4150, ArrayDataType.class);

    public ArrayDataType(DataType nestedType) {
        super("Array<" + nestedType.getName() + ">", 0, nestedType);
        this.setId(this.getName().toLowerCase().hashCode());
    }

    public ArrayDataType(DataType nestedType, int code) {
        super("Array<" + nestedType.getName() + ">", code, nestedType);
    }

    @Override
    public ArrayDataType clone() {
        return (ArrayDataType)super.clone();
    }

    @Override
    public Array createFieldValue() {
        return new Array((DataType)this);
    }

    @Override
    public Class getValueClass() {
        return Array.class;
    }

    @Override
    public FieldPath buildFieldPath(String remainFieldName) {
        if (remainFieldName.length() > 0 && remainFieldName.charAt(0) == '[') {
            int endPos = remainFieldName.indexOf(93);
            if (endPos == -1) {
                throw new IllegalArgumentException("Array subscript must be closed with ]");
            }
            FieldPath path = this.getNestedType().buildFieldPath(ArrayDataType.skipDotInString(remainFieldName, endPos));
            ArrayList<FieldPathEntry> tmpPath = new ArrayList<FieldPathEntry>(path.getList());
            if (remainFieldName.charAt(1) == '$') {
                tmpPath.add(0, FieldPathEntry.newVariableLookupEntry(remainFieldName.substring(2, endPos), this.getNestedType()));
            } else {
                tmpPath.add(0, FieldPathEntry.newArrayLookupEntry(Integer.parseInt(remainFieldName.substring(1, endPos)), this.getNestedType()));
            }
            return new FieldPath(tmpPath);
        }
        return this.getNestedType().buildFieldPath(remainFieldName);
    }
}

