/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.json.JsonReader;
import com.yahoo.document.json.document.DocumentParser;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import java.io.IOException;
import java.io.InputStream;

public class SingleDocumentParser {
    private static final JsonFactory jsonFactory = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private DocumentTypeManager docMan;

    public SingleDocumentParser(DocumentTypeManager docMan) {
        this.docMan = docMan;
    }

    public VespaXMLFeedReader.Operation parsePut(InputStream inputStream, String docId) {
        return this.parse(inputStream, docId, DocumentParser.SupportedOperation.PUT);
    }

    public VespaXMLFeedReader.Operation parseUpdate(InputStream inputStream, String docId) {
        return this.parse(inputStream, docId, DocumentParser.SupportedOperation.UPDATE);
    }

    private VespaXMLFeedReader.Operation parse(InputStream inputStream, String docId, DocumentParser.SupportedOperation supportedOperation) {
        JsonReader reader = new JsonReader(this.docMan, inputStream, jsonFactory);
        DocumentOperation documentOperation = reader.readSingleDocument(supportedOperation, docId);
        VespaXMLFeedReader.Operation operation = new VespaXMLFeedReader.Operation();
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (supportedOperation == DocumentParser.SupportedOperation.PUT) {
            operation.setDocument(((DocumentPut)documentOperation).getDocument());
        } else {
            operation.setDocumentUpdate((DocumentUpdate)documentOperation);
        }
        operation.setCondition(documentOperation.getCondition());
        return operation;
    }
}

