/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docprocs.indexing;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.docprocs.indexing.DocumentScript;
import com.yahoo.docprocs.indexing.ScriptManager;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Chunker;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.FieldGenerator;
import com.yahoo.language.provider.DefaultEmbedderProvider;
import com.yahoo.language.provider.DefaultGeneratorProvider;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.indexinglanguage.FieldValuesFactory;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Provides(value={"indexedDocument"})
@Before(value={"indexingEnd"})
@After(value={"indexingStart", "*"})
public class IndexingProcessor
extends DocumentProcessor {
    public static final String PROVIDED_NAME = "indexedDocument";
    public static final String INDEXING_START = "indexingStart";
    public static final String INDEXING_END = "indexingEnd";
    private final DocumentTypeManager documentTypeManager;
    private final ScriptManager scriptManager;
    private final FieldValuesFactory fieldValuesFactory;

    @Inject
    public IndexingProcessor(DocumentTypeManager documentTypeManager, IlscriptsConfig ilscriptsConfig, Linguistics linguistics, ComponentRegistry<Chunker> chunkers, ComponentRegistry<Embedder> embedders, ComponentRegistry<FieldGenerator> generators) {
        this(documentTypeManager, new ScriptManager(documentTypeManager, ilscriptsConfig, linguistics, IndexingProcessor.toMap(chunkers, null), IndexingProcessor.toMap(embedders, DefaultEmbedderProvider.class), IndexingProcessor.toMap(generators, DefaultGeneratorProvider.class)));
    }

    public IndexingProcessor(DocumentTypeManager documentTypeManager, ScriptManager scriptManager) {
        this.documentTypeManager = documentTypeManager;
        this.scriptManager = scriptManager;
        this.fieldValuesFactory = new FieldValuesFactory((FieldValuesFactory.SelectExpression)new ExpressionSelector());
    }

    public DocumentProcessor.Progress process(Processing proc) {
        if (proc.getDocumentOperations().isEmpty()) {
            return DocumentProcessor.Progress.DONE;
        }
        ArrayList<DocumentOperation> out = new ArrayList<DocumentOperation>(proc.getDocumentOperations().size());
        for (DocumentOperation documentOperation : proc.getDocumentOperations()) {
            if (documentOperation instanceof DocumentPut) {
                this.processDocument((DocumentPut)documentOperation, out);
                continue;
            }
            if (documentOperation instanceof DocumentUpdate) {
                this.processUpdate((DocumentUpdate)documentOperation, out);
                continue;
            }
            if (documentOperation instanceof DocumentRemove) {
                this.processRemove((DocumentRemove)documentOperation, out);
                continue;
            }
            if (documentOperation != null) {
                throw new IllegalArgumentException("Document class " + documentOperation.getClass().getName() + " not supported.");
            }
            throw new IllegalArgumentException("Expected document, got null.");
        }
        proc.getDocumentOperations().clear();
        proc.getDocumentOperations().addAll(out);
        return DocumentProcessor.Progress.DONE;
    }

    DocumentTypeManager getDocumentTypeManager() {
        return this.documentTypeManager;
    }

    private void processDocument(DocumentPut input, List<DocumentOperation> out) {
        Document output;
        DocumentType hadType = input.getDocument().getDataType();
        DocumentScript script = this.scriptManager.getScript(hadType);
        if (script == null) {
            out.add((DocumentOperation)input);
            return;
        }
        DocumentType wantType = this.documentTypeManager.getDocumentType(hadType.getName());
        Document inputDocument = input.getDocument();
        if (hadType != wantType) {
            GrowableByteBuffer buffer = new GrowableByteBuffer(65536, 2.0f);
            DocumentSerializer serializer = DocumentSerializerFactory.createHead((GrowableByteBuffer)buffer);
            serializer.write(inputDocument);
            buffer.flip();
            inputDocument = this.documentTypeManager.createDocument(buffer);
        }
        if ((output = script.execute(this.fieldValuesFactory, inputDocument)) == null) {
            return;
        }
        out.add((DocumentOperation)new DocumentPut(input, output));
    }

    private void processUpdate(DocumentUpdate input, List<DocumentOperation> out) {
        DocumentScript script = this.scriptManager.getScript(input.getType());
        if (script == null) {
            out.add((DocumentOperation)input);
            return;
        }
        DocumentUpdate output = script.execute(this.fieldValuesFactory, input);
        if (output == null) {
            return;
        }
        output.setCondition(input.getCondition());
        out.add((DocumentOperation)output);
    }

    private void processRemove(DocumentRemove input, List<DocumentOperation> out) {
        out.add((DocumentOperation)input);
    }

    private static <T> Map<String, T> toMap(ComponentRegistry<T> registry, Class<?> defaultProviderClass) {
        Map<String, Object> map = registry.allComponentsById().entrySet().stream().collect(Collectors.toMap((? super T e) -> ((ComponentId)e.getKey()).stringValue(), Map.Entry::getValue));
        if (map.size() > 1 && defaultProviderClass != null) {
            map.remove(defaultProviderClass.getName());
        }
        return map;
    }

    private class ExpressionSelector
    extends FieldValuesFactory.SelectExpression {
        private ExpressionSelector() {
        }

        public Expression selectExpression(DocumentType documentType, String fieldName) {
            DocumentScript script = IndexingProcessor.this.scriptManager.getScript(documentType, fieldName);
            if (script == null) {
                throw new IllegalArgumentException("No indexing statement taking only '" + fieldName + "' as input");
            }
            return IndexingProcessor.this.scriptManager.getScript(documentType, fieldName).getExpression();
        }
    }
}

