/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docprocs.indexing;

import com.google.inject.Inject;
import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.docprocs.indexing.DocumentScript;
import com.yahoo.docprocs.indexing.FastLogger;
import com.yahoo.docprocs.indexing.ScriptManager;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.provider.DefaultEmbedderProvider;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.indexinglanguage.AdapterFactory;
import com.yahoo.vespa.indexinglanguage.SimpleAdapterFactory;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;

@Provides(value={"indexedDocument"})
@Before(value={"indexingEnd"})
@After(value={"indexingStart", "*"})
public class IndexingProcessor
extends DocumentProcessor {
    public static final String PROVIDED_NAME = "indexedDocument";
    public static final String INDEXING_START = "indexingStart";
    public static final String INDEXING_END = "indexingEnd";
    private static final FastLogger log = FastLogger.getLogger(IndexingProcessor.class.getName());
    private final DocumentTypeManager docTypeMgr;
    private final ScriptManager scriptMgr;
    private final AdapterFactory adapterFactory;

    @Inject
    public IndexingProcessor(DocumentTypeManager documentTypeManager, IlscriptsConfig ilscriptsConfig, Linguistics linguistics, ComponentRegistry<Embedder> embedders) {
        this.docTypeMgr = documentTypeManager;
        this.scriptMgr = new ScriptManager(this.docTypeMgr, ilscriptsConfig, linguistics, this.toMap(embedders));
        this.adapterFactory = new SimpleAdapterFactory((SimpleAdapterFactory.SelectExpression)new ExpressionSelector());
    }

    public DocumentProcessor.Progress process(Processing proc) {
        if (proc.getDocumentOperations().isEmpty()) {
            return DocumentProcessor.Progress.DONE;
        }
        ArrayList<DocumentOperation> out = new ArrayList<DocumentOperation>(proc.getDocumentOperations().size());
        for (DocumentOperation documentOperation : proc.getDocumentOperations()) {
            if (documentOperation instanceof DocumentPut) {
                this.processDocument((DocumentPut)documentOperation, out);
                continue;
            }
            if (documentOperation instanceof DocumentUpdate) {
                this.processUpdate((DocumentUpdate)documentOperation, out);
                continue;
            }
            if (documentOperation instanceof DocumentRemove) {
                this.processRemove((DocumentRemove)documentOperation, out);
                continue;
            }
            if (documentOperation != null) {
                throw new IllegalArgumentException("Document class " + documentOperation.getClass().getName() + " not supported.");
            }
            throw new IllegalArgumentException("Expected document, got null.");
        }
        proc.getDocumentOperations().clear();
        proc.getDocumentOperations().addAll(out);
        return DocumentProcessor.Progress.DONE;
    }

    DocumentTypeManager getDocumentTypeManager() {
        return this.docTypeMgr;
    }

    private void processDocument(DocumentPut prev, List<DocumentOperation> out) {
        DocumentScript script = this.scriptMgr.getScript(prev.getDocument().getDataType());
        if (script == null) {
            log.log(Level.FINE, "No indexing script for document '%s'.", prev.getId());
            out.add((DocumentOperation)prev);
            return;
        }
        log.log(Level.FINE, "Processing document '%s'.", prev.getId());
        Document next = script.execute(this.adapterFactory, prev.getDocument());
        if (next == null) {
            log.log(Level.FINE, "Document '%s' produced no output.", prev.getId());
            return;
        }
        out.add((DocumentOperation)new DocumentPut(prev, next));
    }

    private void processUpdate(DocumentUpdate prev, List<DocumentOperation> out) {
        DocumentScript script = this.scriptMgr.getScript(prev.getType());
        if (script == null) {
            log.log(Level.FINE, "No indexing script for update '%s'.", prev.getId());
            out.add((DocumentOperation)prev);
            return;
        }
        log.log(Level.FINE, "Processing update '%s'.", prev.getId());
        DocumentUpdate next = script.execute(this.adapterFactory, prev);
        if (next == null) {
            log.log(Level.FINE, "Update '%s' produced no output.", prev.getId());
            return;
        }
        next.setCondition(prev.getCondition());
        out.add((DocumentOperation)next);
    }

    private void processRemove(DocumentRemove prev, List<DocumentOperation> out) {
        log.log(Level.FINE, "Not processing remove '%s'.", prev.getId());
        out.add((DocumentOperation)prev);
    }

    private Map<String, Embedder> toMap(ComponentRegistry<Embedder> embedders) {
        Map<String, Embedder> map = embedders.allComponentsById().entrySet().stream().collect(Collectors.toMap(e -> ((ComponentId)e.getKey()).stringValue(), Map.Entry::getValue));
        if (map.size() > 1) {
            map.remove(DefaultEmbedderProvider.class.getName());
        }
        return map;
    }

    private class ExpressionSelector
    extends SimpleAdapterFactory.SelectExpression {
        private ExpressionSelector() {
        }

        public Expression selectExpression(DocumentType documentType, String fieldName) {
            return IndexingProcessor.this.scriptMgr.getScript(documentType, fieldName).getExpression();
        }
    }
}

