/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docprocs.indexing;

import com.yahoo.docprocs.indexing.DocumentScript;
import com.yahoo.docprocs.indexing.FastLogger;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Encoder;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.parser.CharStream;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ScriptManager {
    private static final FastLogger log = FastLogger.getLogger(ScriptManager.class.getName());
    private static final String FULL = "[all]";
    private final Map<String, Map<String, DocumentScript>> documentFieldScripts;
    private final DocumentTypeManager docTypeMgr;

    public ScriptManager(DocumentTypeManager docTypeMgr, IlscriptsConfig config, Linguistics linguistics, Encoder encoder) {
        this.docTypeMgr = docTypeMgr;
        this.documentFieldScripts = ScriptManager.createScriptsMap(docTypeMgr, config, linguistics, encoder);
    }

    private Map<String, DocumentScript> getScripts(DocumentType inputType) {
        Map<String, DocumentScript> scripts = this.documentFieldScripts.get(inputType.getName());
        if (scripts != null) {
            log.log(Level.FINE, "Using script for type '%s'.", inputType.getName());
            return scripts;
        }
        for (Map.Entry<String, Map<String, DocumentScript>> entry : this.documentFieldScripts.entrySet()) {
            if (!inputType.inherits(this.docTypeMgr.getDocumentType(entry.getKey()))) continue;
            log.log(Level.FINE, "Using script of super-type '%s'.", entry.getKey());
            return entry.getValue();
        }
        for (Map.Entry<String, Map<String, DocumentScript>> entry : this.documentFieldScripts.entrySet()) {
            if (!this.docTypeMgr.getDocumentType(entry.getKey()).inherits(inputType)) continue;
            log.log(Level.FINE, "Using script of sub-type '%s'.", entry.getKey());
            return entry.getValue();
        }
        log.log(Level.FINE, "No script for type '%s'.", inputType.getName());
        return null;
    }

    public DocumentScript getScript(DocumentType inputType) {
        return this.getScript(inputType, FULL);
    }

    public DocumentScript getScript(DocumentType inputType, String inputFieldName) {
        DocumentScript script;
        Map<String, DocumentScript> fieldScripts = this.getScripts(inputType);
        if (fieldScripts != null && (script = fieldScripts.get(inputFieldName)) != null) {
            log.log(Level.FINE, "Using script for type '%s' and field '%s'.", inputType.getName(), inputFieldName);
            return script;
        }
        return null;
    }

    private static Map<String, Map<String, DocumentScript>> createScriptsMap(DocumentTypeManager docTypeMgr, IlscriptsConfig config, Linguistics linguistics, Encoder encoder) {
        HashMap documentFieldScripts = new HashMap(config.ilscript().size());
        ScriptParserContext parserContext = new ScriptParserContext(linguistics, encoder);
        parserContext.getAnnotatorConfig().setMaxTermOccurrences(config.maxtermoccurrences());
        parserContext.getAnnotatorConfig().setMaxTokenLength(config.fieldmatchmaxlength());
        for (IlscriptsConfig.Ilscript ilscript : config.ilscript()) {
            InputExpression.FieldPathOptimizer fieldPathOptimizer = new InputExpression.FieldPathOptimizer(docTypeMgr.getDocumentType(ilscript.doctype()));
            ArrayList<StatementExpression> expressions = new ArrayList<StatementExpression>(ilscript.content().size());
            HashMap<String, DocumentScript> fieldScripts = new HashMap<String, DocumentScript>(ilscript.content().size());
            for (String content : ilscript.content()) {
                expressions.add(ScriptManager.parse(ilscript.doctype(), parserContext, content));
                StatementExpression statement = ScriptManager.parse(ilscript.doctype(), parserContext, content);
                InputExpression.InputFieldNameExtractor inputFieldNameExtractor = new InputExpression.InputFieldNameExtractor();
                statement.select((ObjectPredicate)inputFieldNameExtractor, (ObjectOperation)inputFieldNameExtractor);
                statement.select((ObjectPredicate)fieldPathOptimizer, (ObjectOperation)fieldPathOptimizer);
                if (inputFieldNameExtractor.getInputFieldNames().size() == 1) {
                    ScriptExpression script;
                    String fieldName = (String)inputFieldNameExtractor.getInputFieldNames().get(0);
                    if (fieldScripts.containsKey(fieldName)) {
                        DocumentScript prev = (DocumentScript)fieldScripts.get(fieldName);
                        ArrayList<StatementExpression> appendedList = new ArrayList<StatementExpression>(((ScriptExpression)prev.getExpression()).asList());
                        appendedList.add(statement);
                        script = new ScriptExpression(appendedList);
                        log.log(Level.FINE, "Appending script for field '" + fieldName + "' = " + statement, new Object[0]);
                        log.log(Level.FINE, "Full script for field '" + fieldName + "' = " + appendedList, new Object[0]);
                    } else {
                        script = new ScriptExpression(new StatementExpression[]{statement});
                        log.log(Level.FINE, "Setting script for field '" + fieldName + "' = " + statement, new Object[0]);
                    }
                    DocumentScript documentScript = new DocumentScript(ilscript.doctype(), inputFieldNameExtractor.getInputFieldNames(), (Expression)script);
                    fieldScripts.put(fieldName, documentScript);
                    continue;
                }
                log.log(Level.FINE, "Non single(" + inputFieldNameExtractor.getInputFieldNames().size() + ") inputs = " + inputFieldNameExtractor.getInputFieldNames() + ". Script = " + statement, new Object[0]);
            }
            ScriptExpression script = new ScriptExpression(expressions);
            script.select((ObjectPredicate)fieldPathOptimizer, (ObjectOperation)fieldPathOptimizer);
            fieldScripts.put(FULL, new DocumentScript(ilscript.doctype(), ilscript.docfield(), (Expression)script));
            documentFieldScripts.put(ilscript.doctype(), Collections.unmodifiableMap(fieldScripts));
        }
        return Collections.unmodifiableMap(documentFieldScripts);
    }

    private static StatementExpression parse(String docType, ScriptParserContext parserConfig, String content) {
        parserConfig.setInputStream((CharStream)new IndexingInput(content));
        try {
            return StatementExpression.newInstance((ScriptParserContext)parserConfig);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal indexing script for document type '" + docType + "'; " + content, e);
        }
    }
}

