/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.collections.Pair;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.docproc.Accesses;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.Processing;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public abstract class DocumentProcessor
extends ChainedComponent {
    static Logger log = Logger.getLogger(DocprocService.class.getName());
    private Map<Pair<String, String>, String> fieldMap = new HashMap<Pair<String, String>, String>();
    private Map<String, Map<String, String>> docMapCache = new HashMap<String, Map<String, String>>();
    final boolean hasAnnotations = ((Object)((Object)this)).getClass().getAnnotation(Accesses.class) != null;

    final boolean hasAnnotations() {
        return this.hasAnnotations;
    }

    public abstract Progress process(Processing var1);

    public String toString() {
        return "processor " + this.getId().stringValue();
    }

    public void setFieldMap(Map<Pair<String, String>, String> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public Map<Pair<String, String>, String> getFieldMap() {
        return this.fieldMap;
    }

    public Map<String, String> getDocMap(String docType) {
        Map<String, String> cached = this.docMapCache.get(docType);
        if (cached != null) {
            return cached;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<Pair<String, String>, String> e : this.fieldMap.entrySet()) {
            if (!docType.equals(e.getKey().getFirst()) && e.getKey().getFirst() != null && !"".equals(e.getKey().getFirst())) continue;
            ret.put((String)e.getKey().getSecond(), e.getValue());
        }
        this.docMapCache.put(docType, ret);
        return ret;
    }

    public static final class LaterProgress
    extends Progress {
        private final long delay;
        public static final long DEFAULT_LATER_DELAY = 20L;

        private LaterProgress() {
            this(20L);
        }

        private LaterProgress(long delay) {
            super("later");
            this.delay = delay;
        }

        public long getDelay() {
            return this.delay;
        }
    }

    public static class Progress {
        public static final Progress DONE = new Progress("done");
        public static final Progress LATER = new LaterProgress();
        public static final Progress FAILED = new Progress("failed");
        public static final Progress PERMANENT_FAILURE = new Progress("permanent_failure");
        private String name;
        private Optional<String> reason = Optional.empty();

        protected Progress(String name) {
            this.name = name;
        }

        protected Progress(String name, String reason) {
            this(name);
            this.reason = Optional.of(reason);
        }

        public static Progress later(long delay) {
            return new LaterProgress(delay);
        }

        public Progress withReason(String reason) {
            return new Progress(this.name, reason);
        }

        public String toString() {
            return this.name;
        }

        public Optional<String> getReason() {
            return this.reason;
        }

        public boolean equals(Object object) {
            return object instanceof Progress && ((Progress)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

