/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc.messagebus;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.TraceNode;
import com.yahoo.messagebus.jdisc.MbusResponse;
import com.yahoo.messagebus.jdisc.StatusCodes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class ResponseMerger
implements ResponseHandler {
    private final Message requestMsg;
    private final TraceNode requestTrace = new TraceNode().setStrict(false);
    private final ResponseHandler responseHandler;
    private final List<Reply> replies;
    private int numPending;

    public ResponseMerger(Message requestMsg, int numPending, ResponseHandler responseHandler) {
        this.requestMsg = requestMsg;
        this.responseHandler = responseHandler;
        this.replies = new ArrayList<Reply>(numPending);
        this.numPending = numPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentChannel handleResponse(Response response) {
        ResponseMerger responseMerger = this;
        synchronized (responseMerger) {
            if (response instanceof MbusResponse) {
                Reply reply = ((MbusResponse)response).getReply();
                this.requestTrace.addChild(reply.getTrace().getRoot());
                this.replies.add(reply);
            }
            if (--this.numPending != 0) {
                return null;
            }
        }
        this.requestMsg.getTrace().getRoot().addChild(this.requestTrace);
        Reply reply = DocumentProtocol.merge(this.replies);
        MbusResponse mbusResponse = new MbusResponse(StatusCodes.fromMbusReply((Reply)reply), reply);
        ResponseDispatch.newInstance((Response)mbusResponse, (ByteBuffer[])new ByteBuffer[0]).dispatch(this.responseHandler);
        return null;
    }
}

