/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.component.ComponentId;
import com.yahoo.concurrent.SystemTimer;
import com.yahoo.docproc.DocumentOperationWrapper;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.docproc.jdisc.metric.NullMetric;
import com.yahoo.docproc.proxy.ProxyDocument;
import com.yahoo.docproc.proxy.ProxyDocumentUpdate;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.jdisc.Metric;
import com.yahoo.statistics.Counter;
import com.yahoo.statistics.Statistics;
import java.util.List;

public class Call
implements Cloneable {
    private final DocumentProcessor processor;
    private final Counter docCounter;
    private final String docCounterName;
    private final Counter procTimeCounter;
    private final String procTimeCounterName;
    private final Metric metric;

    public Call(DocumentProcessor processor) {
        this(processor, Statistics.nullImplementation, new NullMetric());
    }

    public Call(DocumentProcessor processor, Statistics manager, Metric metric) {
        this(processor, "", manager, metric);
    }

    public Call(DocumentProcessor processor, String chainName, Statistics manager, Metric metric) {
        this.processor = processor;
        if (chainName == null) {
            chainName = "";
        }
        chainName = chainName.replaceAll("[^\\p{Alnum}]", "_");
        this.docCounterName = "docprocessor_" + chainName + "_" + this.getDocumentProcessorId().stringValue().replaceAll("[^\\p{Alnum}]", "_") + "_documents";
        this.procTimeCounterName = "docprocessor_" + chainName + "_" + this.getDocumentProcessorId().stringValue().replaceAll("[^\\p{Alnum}]", "_") + "_proctime";
        this.docCounter = new Counter(this.docCounterName, manager, false);
        this.procTimeCounter = new Counter(this.procTimeCounterName, manager, false, null, true);
        this.metric = metric;
    }

    public Object clone() {
        try {
            Call clone = (Call)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Will not happen");
        }
    }

    public DocumentProcessor getDocumentProcessor() {
        return this.processor;
    }

    public ComponentId getDocumentProcessorId() {
        return this.processor.getId();
    }

    public DocumentPut configDoc(DocumentProcessor docProc, DocumentPut documentPut) {
        if (!docProc.getFieldMap().isEmpty() || docProc.hasAnnotations()) {
            Document document = documentPut.getDocument();
            document = new ProxyDocument(docProc, document, docProc.getDocMap(document.getDataType().getName()));
            DocumentPut newDocumentPut = new DocumentPut(document);
            newDocumentPut.setCondition(documentPut.getCondition());
            documentPut = newDocumentPut;
        }
        return documentPut;
    }

    private DocumentUpdate configDocUpd(DocumentProcessor proc, DocumentUpdate docU) {
        if (proc.getFieldMap().isEmpty()) {
            return docU;
        }
        return new ProxyDocumentUpdate(docU, proc.getDocMap(docU.getDocumentType().getName()));
    }

    private void schemaMapProcessing(Processing processing) {
        List<DocumentOperation> documentOperations = processing.getDocumentOperations();
        for (int i = 0; i < documentOperations.size(); ++i) {
            DocumentOperation op = documentOperations.get(i);
            if (op instanceof DocumentPut) {
                documentOperations.set(i, (DocumentOperation)this.configDoc(this.processor, (DocumentPut)op));
                continue;
            }
            if (!(op instanceof DocumentUpdate)) continue;
            documentOperations.set(i, (DocumentOperation)this.configDocUpd(this.processor, (DocumentUpdate)op));
        }
    }

    private void unwrapSchemaMapping(Processing processing) {
        List<DocumentOperation> documentOperations = processing.getDocumentOperations();
        for (int i = 0; i < documentOperations.size(); ++i) {
            DocumentPut putOperation;
            DocumentOperation documentOperation = documentOperations.get(i);
            if (!(documentOperation instanceof DocumentPut) || !((putOperation = (DocumentPut)documentOperation).getDocument() instanceof DocumentOperationWrapper)) continue;
            DocumentOperationWrapper proxy = (DocumentOperationWrapper)putOperation.getDocument();
            documentOperations.set(i, (DocumentOperation)new DocumentPut(putOperation, ((DocumentPut)proxy.getWrappedDocumentOperation()).getDocument()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentProcessor.Progress call(Processing processing) {
        try {
            int numDocs = processing.getDocumentOperations().size();
            this.schemaMapProcessing(processing);
            long startTime = SystemTimer.INSTANCE.milliTime();
            DocumentProcessor.Progress retval = this.processor.process(processing);
            this.incrementProcTime(SystemTimer.INSTANCE.milliTime() - startTime);
            this.incrementDocs(numDocs);
            DocumentProcessor.Progress progress = retval;
            return progress;
        }
        finally {
            this.unwrapSchemaMapping(processing);
        }
    }

    public String toString() {
        return "call to class " + ((Object)((Object)this.processor)).getClass().getName() + " (id: " + this.getDocumentProcessorId() + ")";
    }

    private void incrementDocs(long increment) {
        this.docCounter.increment(increment);
        this.metric.add(this.docCounterName, (Number)increment, null);
    }

    private void incrementProcTime(long increment) {
        this.procTimeCounter.increment(increment);
        this.metric.add(this.procTimeCounterName, (Number)increment, null);
    }
}

