/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc.messagebus;

import com.yahoo.docproc.Processing;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.messagebus.loadtypes.LoadType;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import java.util.logging.Level;
import java.util.logging.Logger;

class MessageFactory {
    private static final Logger log = Logger.getLogger(MessageFactory.class.getName());
    private final Message requestMsg;
    private final LoadType loadType;
    private final DocumentProtocol.Priority priority;

    public MessageFactory(DocumentMessage requestMsg) {
        this.requestMsg = requestMsg;
        this.loadType = requestMsg.getLoadType();
        this.priority = requestMsg.getPriority();
    }

    public DocumentMessage fromDocumentOperation(Processing processing, DocumentOperation documentOperation) {
        DocumentMessage msg = MessageFactory.newMessage(documentOperation);
        msg.setLoadType(this.loadType);
        msg.setPriority(this.priority);
        msg.setRoute(this.requestMsg.getRoute());
        msg.setTimeReceivedNow();
        msg.setTimeRemaining(this.requestMsg.getTimeRemainingNow());
        msg.getTrace().setLevel(this.requestMsg.getTrace().getLevel());
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Created '" + msg.getClass().getName() + "', route = '" + msg.getRoute() + "', priority = '" + msg.getPriority().name() + "', load type = '" + msg.getLoadType() + "', trace level = '" + msg.getTrace().getLevel() + "', time remaining = '" + msg.getTimeRemaining() + "'.");
        }
        return msg;
    }

    private static DocumentMessage newMessage(DocumentOperation documentOperation) {
        PutDocumentMessage message;
        if (documentOperation instanceof DocumentPut) {
            message = new PutDocumentMessage((DocumentPut)documentOperation);
        } else if (documentOperation instanceof DocumentUpdate) {
            message = new UpdateDocumentMessage((DocumentUpdate)documentOperation);
        } else if (documentOperation instanceof DocumentRemove) {
            message = new RemoveDocumentMessage(documentOperation.getId());
        } else {
            throw new UnsupportedOperationException(documentOperation.getClass().getName());
        }
        message.setCondition(documentOperation.getCondition());
        return message;
    }
}

