/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.spifly.dynamic;

import com.yahoo.vespa.spifly.repackaged.asm.ClassReader;
import com.yahoo.vespa.spifly.repackaged.asm.util.CheckClassAdapter;
import com.yahoo.vespa.spifly.repackaged.asm.util.TraceClassVisitor;
import com.yahoo.vespa.spifly.repackaged.spifly.Util;
import com.yahoo.vespa.spifly.repackaged.spifly.WeavingData;
import com.yahoo.vespa.spifly.repackaged.spifly.dynamic.DynamicWeavingActivator;
import com.yahoo.vespa.spifly.repackaged.spifly.dynamic.OSGiFriendlyClassWriter;
import com.yahoo.vespa.spifly.repackaged.spifly.weaver.TCCLSetterVisitor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.logging.Level;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

public class ClientWeavingHook
implements WeavingHook {
    private final String addedImport;
    private final DynamicWeavingActivator activator;

    ClientWeavingHook(BundleContext context, DynamicWeavingActivator dwActivator) {
        this.activator = dwActivator;
        this.addedImport = Util.class.getPackage().getName();
    }

    public void weave(WovenClass wovenClass) {
        Bundle consumerBundle = wovenClass.getBundleWiring().getBundle();
        Set<WeavingData> wd = this.activator.getWeavingData(consumerBundle);
        if (wd != null) {
            this.activator.log(Level.FINE, "Weaving class " + wovenClass.getClassName());
            ClassReader cr = new ClassReader(wovenClass.getBytes());
            OSGiFriendlyClassWriter cw = new OSGiFriendlyClassWriter(3, wovenClass.getBundleWiring().getClassLoader());
            TCCLSetterVisitor tsv = new TCCLSetterVisitor(cw, wovenClass.getClassName(), wd);
            cr.accept(tsv, 4);
            if (tsv.isWoven()) {
                wovenClass.setBytes(cw.toByteArray());
                if (tsv.additionalImportRequired()) {
                    wovenClass.getDynamicImports().add(this.addedImport);
                }
                if (this.activator.isLogEnabled(Level.FINEST)) {
                    StringWriter stringWriter = new StringWriter();
                    ClassReader reader = new ClassReader(wovenClass.getBytes());
                    TraceClassVisitor tracer = new TraceClassVisitor(new PrintWriter(stringWriter));
                    CheckClassAdapter checker = new CheckClassAdapter(tracer, true);
                    reader.accept(checker, 0);
                    this.activator.log(Level.FINEST, "Woven class bytecode: \n" + stringWriter.toString());
                }
            }
        }
    }
}

