/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.aQute.bnd.version;

import com.yahoo.vespa.spifly.repackaged.aQute.bnd.version.MavenVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MavenVersionRange {
    private static final Pattern RESTRICTION_P = Pattern.compile("\\s*((?<pair>(?<li>\\[|\\()\\s*(?<low>[^,\\s\\]\\[()]*)\\s*,\\s*(?<high>[^,\\s\\[\\]()]*)\\s*(?<hi>\\]|\\)))|(?<single>[^,\\s\\]\\[()]+)|(\\[(?<exact>[^,\\s\\]\\[()]+)\\]))\\s*(?<comma>,)?", 4);
    private final boolean pair;
    private final boolean li;
    private final boolean hi;
    private final MavenVersion low;
    private final MavenVersion high;
    private final MavenVersionRange nextOr;

    public MavenVersionRange(String range) {
        this(RESTRICTION_P.matcher(range == null ? "0" : range));
    }

    private MavenVersionRange(Matcher m) {
        if (!m.lookingAt()) {
            throw new IllegalArgumentException("Invalid version range " + m);
        }
        boolean bl = this.pair = m.group("pair") != null;
        if (this.pair) {
            this.li = m.group("li").equals("[");
            this.hi = m.group("hi").equals("]");
            String v = m.group("low").trim();
            this.low = v.isEmpty() ? MavenVersion.LOWEST : MavenVersion.parseMavenString(v);
            v = m.group("high").trim();
            this.high = v.isEmpty() ? MavenVersion.HIGHEST : MavenVersion.parseMavenString(v);
        } else {
            String single = m.group("single");
            if (single != null) {
                this.hi = true;
                this.li = true;
                this.low = new MavenVersion(single);
                this.high = MavenVersion.HIGHEST;
            } else {
                String exact = m.group("exact");
                this.hi = true;
                this.li = true;
                this.low = this.high = new MavenVersion(exact);
            }
        }
        if (m.group("comma") != null) {
            m.region(m.end(), m.regionEnd());
            this.nextOr = new MavenVersionRange(m);
        } else {
            this.nextOr = null;
        }
    }

    public boolean includes(MavenVersion mvr) {
        boolean highOk;
        int l = mvr.compareTo(this.low);
        int h = this.high == MavenVersion.HIGHEST ? -1 : mvr.compareTo(this.high);
        boolean lowOk = l > 0 || this.li && l == 0;
        boolean bl = highOk = h < 0 || this.hi && h == 0;
        if (lowOk && highOk) {
            return true;
        }
        if (this.nextOr != null) {
            return this.nextOr.includes(mvr);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuilder sb) {
        if (this.pair) {
            sb.append(this.li ? (char)'[' : '(');
            if (this.low != MavenVersion.LOWEST) {
                sb.append(this.low);
            }
            sb.append(',');
            if (this.high != MavenVersion.HIGHEST) {
                sb.append(this.high);
            }
            sb.append(this.hi ? (char)']' : ')');
        } else if (this.low == this.high) {
            sb.append('[').append(this.low).append(']');
        } else {
            sb.append(this.low);
        }
        if (this.nextOr != null) {
            sb.append(',');
            this.nextOr.toString(sb);
        }
    }

    public static MavenVersionRange parseRange(String version) {
        try {
            return new MavenVersionRange(version);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean wasSingle() {
        return !this.pair && this.high == MavenVersion.HIGHEST && this.nextOr == null;
    }

    public static boolean isRange(String version) {
        if (version == null) {
            return false;
        }
        return (version = version.trim()).startsWith("[") || version.startsWith("(");
    }
}

