/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.aQute.bnd.stream;

import com.yahoo.vespa.spifly.repackaged.aQute.bnd.stream.DropWhile;
import com.yahoo.vespa.spifly.repackaged.aQute.bnd.stream.MapStream;
import com.yahoo.vespa.spifly.repackaged.aQute.bnd.stream.TakeWhile;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

final class EntryPipeline<K, V>
implements MapStream<K, V> {
    private final Stream<Map.Entry<K, V>> stream;

    EntryPipeline(Stream<? extends Map.Entry<? extends K, ? extends V>> stream) {
        this.stream = Objects.requireNonNull(stream);
    }

    @Override
    public Stream<Map.Entry<K, V>> entries() {
        return this.stream;
    }

    @Override
    public Stream<K> keys() {
        return this.entries().map(Map.Entry::getKey);
    }

    @Override
    public Stream<V> values() {
        return this.entries().map(Map.Entry::getValue);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entries().iterator();
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.entries().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.entries().isParallel();
    }

    @Override
    public MapStream<K, V> sequential() {
        Stream sequential = (Stream)this.entries().sequential();
        return this.entries() == sequential ? this : new EntryPipeline<K, V>(sequential);
    }

    @Override
    public MapStream<K, V> parallel() {
        Stream parallel = (Stream)this.entries().parallel();
        return this.entries() == parallel ? this : new EntryPipeline<K, V>(parallel);
    }

    @Override
    public MapStream<K, V> unordered() {
        Stream unordered = (Stream)this.entries().unordered();
        return this.entries() == unordered ? this : new EntryPipeline<K, V>(unordered);
    }

    @Override
    public MapStream<K, V> onClose(Runnable closeHandler) {
        Stream onClose = (Stream)this.entries().onClose(closeHandler);
        return this.entries() == onClose ? this : new EntryPipeline<K, V>(onClose);
    }

    @Override
    public void close() {
        this.entries().close();
    }

    @Override
    public MapStream<K, V> distinct() {
        return new EntryPipeline<K, V>(this.entries().distinct());
    }

    @Override
    public MapStream<K, V> filter(BiPredicate<? super K, ? super V> filter) {
        Objects.requireNonNull(filter);
        return new EntryPipeline<K, V>(this.entries().filter((? super T e) -> filter.test((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    public MapStream<K, V> filterKey(Predicate<? super K> filter) {
        Objects.requireNonNull(filter);
        return new EntryPipeline<K, V>(this.entries().filter((? super T e) -> filter.test((Object)e.getKey())));
    }

    @Override
    public MapStream<K, V> filterValue(Predicate<? super V> filter) {
        Objects.requireNonNull(filter);
        return new EntryPipeline<K, V>(this.entries().filter((? super T e) -> filter.test((Object)e.getValue())));
    }

    @Override
    public <R, S> MapStream<R, S> map(BiFunction<? super K, ? super V, ? extends Map.Entry<? extends R, ? extends S>> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryPipeline<K, V>(this.entries().map((? super T e) -> (Map.Entry)mapper.apply((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    public <R> MapStream<R, V> mapKey(Function<? super K, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryPipeline<K, V>(this.entries().map((? super T e) -> MapStream.entry(mapper.apply((Object)e.getKey()), e.getValue())));
    }

    @Override
    public <S> MapStream<K, S> mapValue(Function<? super V, ? extends S> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryPipeline<K, V>(this.entries().map((? super T e) -> MapStream.entry(e.getKey(), mapper.apply((Object)e.getValue()))));
    }

    @Override
    public <R> Stream<R> mapToObj(BiFunction<? super K, ? super V, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().map((? super T e) -> mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public IntStream mapToInt(ToIntBiFunction<? super K, ? super V> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().mapToInt((? super T e) -> mapper.applyAsInt((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public LongStream mapToLong(ToLongBiFunction<? super K, ? super V> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().mapToLong((? super T e) -> mapper.applyAsLong((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleBiFunction<? super K, ? super V> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().mapToDouble((? super T e) -> mapper.applyAsDouble((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public <R, S> MapStream<R, S> flatMap(BiFunction<? super K, ? super V, ? extends MapStream<? extends R, ? extends S>> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryPipeline<K, V>(this.entries().flatMap((? super T e) -> ((MapStream)mapper.apply((Object)e.getKey(), (Object)e.getValue())).entries()));
    }

    @Override
    public <R> MapStream<R, V> flatMapKey(Function<? super K, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryPipeline<K, V>(this.entries().flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getKey())).map((? super T k) -> MapStream.entry(k, e.getValue()))));
    }

    @Override
    public <S> MapStream<K, S> flatMapValue(Function<? super V, ? extends Stream<? extends S>> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryPipeline<K, V>(this.entries().flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getValue())).map((? super T v) -> MapStream.entry(e.getKey(), v))));
    }

    @Override
    public <R> Stream<R> flatMapToObj(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().flatMap((? super T e) -> (Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public IntStream flatMapToInt(BiFunction<? super K, ? super V, ? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().flatMapToInt((? super T e) -> (IntStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public LongStream flatMapToLong(BiFunction<? super K, ? super V, ? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().flatMapToLong((? super T e) -> (LongStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public DoubleStream flatMapToDouble(BiFunction<? super K, ? super V, ? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.entries().flatMapToDouble((? super T e) -> (DoubleStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public MapStream<K, V> peek(BiConsumer<? super K, ? super V> peek) {
        Objects.requireNonNull(peek);
        return new EntryPipeline<K, V>(this.entries().peek((? super T e) -> peek.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    public MapStream<K, V> peekKey(Consumer<? super K> peek) {
        Objects.requireNonNull(peek);
        return new EntryPipeline<K, V>(this.entries().peek((? super T e) -> peek.accept((Object)e.getKey())));
    }

    @Override
    public MapStream<K, V> peekValue(Consumer<? super V> peek) {
        Objects.requireNonNull(peek);
        return new EntryPipeline<K, V>(this.entries().peek((? super T e) -> peek.accept((Object)e.getValue())));
    }

    private static <K, V> Comparator<Map.Entry<K, V>> comparingByKey() {
        return Map.Entry.comparingByKey();
    }

    private static <K, V> Comparator<Map.Entry<K, V>> comparingByValue() {
        return Map.Entry.comparingByValue();
    }

    private static <K, V> Comparator<Map.Entry<K, V>> comparing() {
        return Map.Entry.comparingByKey().thenComparing(Map.Entry.comparingByValue());
    }

    @Override
    public MapStream<K, V> sorted() {
        return this.sorted(EntryPipeline.comparing());
    }

    @Override
    public MapStream<K, V> sorted(Comparator<? super Map.Entry<K, V>> comparator) {
        return new EntryPipeline<K, V>(this.entries().sorted(comparator));
    }

    @Override
    public MapStream<K, V> sortedByKey() {
        return this.sorted(EntryPipeline.comparingByKey());
    }

    @Override
    public MapStream<K, V> sortedByKey(Comparator<? super K> comparator) {
        return this.sorted(Map.Entry.comparingByKey(comparator));
    }

    @Override
    public MapStream<K, V> sortedByValue() {
        return this.sorted(EntryPipeline.comparingByValue());
    }

    @Override
    public MapStream<K, V> sortedByValue(Comparator<? super V> comparator) {
        return this.sorted(Map.Entry.comparingByValue(comparator));
    }

    @Override
    public MapStream<K, V> limit(long maxSize) {
        return new EntryPipeline<K, V>(this.entries().limit(maxSize));
    }

    @Override
    public MapStream<K, V> skip(long n) {
        return new EntryPipeline<K, V>(this.entries().skip(n));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        Objects.requireNonNull(consumer);
        this.entries().forEach((? super T e) -> consumer.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public void forEachOrdered(BiConsumer<? super K, ? super V> consumer) {
        Objects.requireNonNull(consumer);
        this.entries().forEachOrdered((? super T e) -> consumer.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public long count() {
        return this.entries().count();
    }

    @Override
    public boolean anyMatch(BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate);
        return this.entries().anyMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public boolean allMatch(BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate);
        return this.entries().allMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public boolean noneMatch(BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate);
        return this.entries().noneMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public <R, A> R collect(Collector<? super Map.Entry<? extends K, ? extends V>, A, R> collector) {
        return this.entries().collect(collector);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super Map.Entry<? extends K, ? extends V>> accumulator, BiConsumer<R, R> combiner) {
        return this.entries().collect(supplier, accumulator, combiner);
    }

    @Override
    public Optional<Map.Entry<K, V>> max(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.entries().max(comparator);
    }

    @Override
    public Optional<Map.Entry<K, V>> maxByKey(Comparator<? super K> comparator) {
        return this.max(Map.Entry.comparingByKey(comparator));
    }

    @Override
    public Optional<Map.Entry<K, V>> maxByValue(Comparator<? super V> comparator) {
        return this.max(Map.Entry.comparingByValue(comparator));
    }

    @Override
    public Optional<Map.Entry<K, V>> min(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.entries().min(comparator);
    }

    @Override
    public Optional<Map.Entry<K, V>> minByKey(Comparator<? super K> comparator) {
        return this.min(Map.Entry.comparingByKey(comparator));
    }

    @Override
    public Optional<Map.Entry<K, V>> minByValue(Comparator<? super V> comparator) {
        return this.min(Map.Entry.comparingByValue(comparator));
    }

    @Override
    public Optional<Map.Entry<K, V>> findAny() {
        return this.entries().findAny();
    }

    @Override
    public Optional<Map.Entry<K, V>> findFirst() {
        return this.entries().findFirst();
    }

    @Override
    public Map.Entry<K, V>[] toArray() {
        Map.Entry[] array = (Map.Entry[])this.entries().toArray(Map.Entry[]::new);
        return array;
    }

    @Override
    public MapStream<K, V> takeWhile(BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate);
        return new EntryPipeline<K, V>(TakeWhile.takeWhile(this.entries(), e -> predicate.test((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    public MapStream<K, V> takeWhileKey(Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate);
        return new EntryPipeline<K, V>(TakeWhile.takeWhile(this.entries(), e -> predicate.test((Object)e.getKey())));
    }

    @Override
    public MapStream<K, V> takeWhileValue(Predicate<? super V> predicate) {
        Objects.requireNonNull(predicate);
        return new EntryPipeline<K, V>(TakeWhile.takeWhile(this.entries(), e -> predicate.test((Object)e.getValue())));
    }

    @Override
    public MapStream<K, V> dropWhile(BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate);
        return new EntryPipeline<K, V>(DropWhile.dropWhile(this.entries(), e -> predicate.test((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    public MapStream<K, V> dropWhileKey(Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate);
        return new EntryPipeline<K, V>(DropWhile.dropWhile(this.entries(), e -> predicate.test((Object)e.getKey())));
    }

    @Override
    public MapStream<K, V> dropWhileValue(Predicate<? super V> predicate) {
        Objects.requireNonNull(predicate);
        return new EntryPipeline<K, V>(DropWhile.dropWhile(this.entries(), e -> predicate.test((Object)e.getValue())));
    }
}

