/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.spifly;

import com.yahoo.vespa.spifly.repackaged.spifly.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArgRestrictions {
    private final Map<Pair<Integer, String>, List<String>> restrictions = new HashMap<Pair<Integer, String>, List<String>>();

    public void addRestriction(int argNumber, String className) {
        this.addRestriction(argNumber, className, null);
    }

    public void addRestriction(int argNumber, String className, String allowedArgValue) {
        Pair<Integer, String> key = new Pair<Integer, String>(argNumber, className);
        List<String> allowedValues = this.restrictions.get(key);
        if (allowedArgValue != null) {
            if (allowedValues == null) {
                allowedValues = new ArrayList<String>();
                this.restrictions.put(key, allowedValues);
            }
            allowedValues.add(allowedArgValue);
        }
        this.restrictions.put(key, allowedValues);
    }

    public String[] getArgClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        for (Pair<Integer, String> key : this.restrictions.keySet()) {
            classes.add(key.getRight());
        }
        if (classes.size() == 0) {
            return null;
        }
        return classes.toArray(new String[classes.size()]);
    }

    public boolean matches(Map<Pair<Integer, String>, String> args) {
        for (Pair<Integer, String> key : args.keySet()) {
            String val;
            if (!this.restrictions.containsKey(key)) {
                return false;
            }
            List<String> values = this.restrictions.get(key);
            if (values == null || values.contains(val = args.get(key))) continue;
            return false;
        }
        return true;
    }
}

