/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.aQute.libg.glob;

import com.yahoo.vespa.spifly.repackaged.aQute.libg.glob.AntGlob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathSet {
    private final List<Pattern> includes = new ArrayList<Pattern>();
    private final List<Pattern> excludes = new ArrayList<Pattern>();

    public PathSet() {
    }

    public PathSet(String ... includes) {
        this.include(includes);
    }

    public PathSet includes(List<String> includes) {
        if (includes != null) {
            PathSet.addPatterns(includes.stream(), this.includes);
        }
        return this;
    }

    public PathSet include(String ... includes) {
        if (includes != null) {
            PathSet.addPatterns(Arrays.stream(includes), this.includes);
        }
        return this;
    }

    public PathSet exclude(String ... excludes) {
        if (excludes != null) {
            PathSet.addPatterns(Arrays.stream(excludes), this.excludes);
        }
        return this;
    }

    public PathSet excludes(List<String> excludes) {
        if (excludes != null) {
            PathSet.addPatterns(excludes.stream(), this.excludes);
        }
        return this;
    }

    private static List<Pattern> addPatterns(Stream<String> globs, List<Pattern> patterns) {
        globs.filter(Objects::nonNull).map(AntGlob::toPattern).forEachOrdered(patterns::add);
        return patterns;
    }

    public List<String> paths(Collection<String> paths, String ... defaultIncludes) {
        return PathSet.paths(paths, this.matches(defaultIncludes));
    }

    public List<String> paths(Collection<String> paths, List<String> defaultIncludes) {
        return PathSet.paths(paths, this.matches(defaultIncludes));
    }

    public List<String> paths(Collection<String> paths) {
        return PathSet.paths(paths, this.matches());
    }

    private static List<String> paths(Collection<String> paths, Predicate<String> matches) {
        return paths.stream().filter(matches).collect(Collectors.toList());
    }

    public Predicate<String> matches(String ... defaultIncludes) {
        return this.matcher(Matcher::matches, defaultIncludes);
    }

    public Predicate<String> matches(List<String> defaultIncludes) {
        return this.matcher(Matcher::matches, defaultIncludes);
    }

    public Predicate<String> matches() {
        return this.matcher(Matcher::matches);
    }

    public Predicate<String> find(String ... defaultIncludes) {
        return this.matcher(Matcher::find, defaultIncludes);
    }

    public Predicate<String> find(List<String> defaultIncludes) {
        return this.matcher(Matcher::find, defaultIncludes);
    }

    public Predicate<String> find() {
        return this.matcher(Matcher::find);
    }

    private Predicate<String> matcher(Predicate<Matcher> predicate, String ... defaultIncludes) {
        if (this.includes.isEmpty() && defaultIncludes != null && defaultIncludes.length > 0) {
            return PathSet.matcher(predicate, PathSet.addPatterns(Arrays.stream(defaultIncludes), new ArrayList<Pattern>()), this.excludes);
        }
        return PathSet.matcher(predicate, this.includes, this.excludes);
    }

    private Predicate<String> matcher(Predicate<Matcher> predicate, List<String> defaultIncludes) {
        if (this.includes.isEmpty() && defaultIncludes != null && !defaultIncludes.isEmpty()) {
            return PathSet.matcher(predicate, PathSet.addPatterns(defaultIncludes.stream(), new ArrayList<Pattern>()), this.excludes);
        }
        return PathSet.matcher(predicate, this.includes, this.excludes);
    }

    private Predicate<String> matcher(Predicate<Matcher> predicate) {
        return PathSet.matcher(predicate, this.includes, this.excludes);
    }

    private static Predicate<String> matcher(Predicate<Matcher> predicate, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        if (includePatterns.isEmpty()) {
            return path -> false;
        }
        if (excludePatterns.isEmpty()) {
            if (includePatterns.size() == 1) {
                Pattern include = includePatterns.get(0);
                return path -> predicate.test(include.matcher((CharSequence)path));
            }
            ArrayList<Pattern> includes = new ArrayList<Pattern>(includePatterns);
            return path -> includes.stream().anyMatch(include -> predicate.test(include.matcher((CharSequence)path)));
        }
        ArrayList<Pattern> includes = new ArrayList<Pattern>(includePatterns);
        ArrayList<Pattern> excludes = new ArrayList<Pattern>(excludePatterns);
        return path -> includes.stream().anyMatch(include -> predicate.test(include.matcher((CharSequence)path))) && excludes.stream().noneMatch(exclude -> predicate.test(exclude.matcher((CharSequence)path)));
    }

    public String toString() {
        return String.format("[includes: %s, excludes: %s]", this.includes, this.excludes);
    }
}

