/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.spifly;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class MultiDelegationClassloader
extends ClassLoader {
    private final ClassLoader[] delegates;

    public MultiDelegationClassloader(ClassLoader ... classLoaders) {
        if (classLoaders == null) {
            throw new NullPointerException();
        }
        this.delegates = (ClassLoader[])classLoaders.clone();
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader cl : this.delegates) {
            URL res = cl.getResource(name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader cl : this.delegates) {
            InputStream is = cl.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader cl : this.delegates) {
            urls.addAll(Collections.list(cl.getResources(name)));
        }
        return Collections.enumeration(urls);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassNotFoundException lastEx = null;
        for (ClassLoader cl : this.delegates) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                lastEx = e;
            }
        }
        throw lastEx;
    }
}

