/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.metrics.simple.Gauge;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.Point;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;

@After(value={"backend"})
public class ContainerLatencySearcher
extends Searcher {
    private final Gauge latencyGauge;

    public ContainerLatencySearcher(MetricReceiver metrics) {
        this.latencyGauge = metrics.declareGauge("query_container_latency");
    }

    @Override
    public Result search(Query query, Execution execution) {
        Point dims = this.latencyGauge.builder().set("chain", execution.chain().getId().stringValue()).build();
        this.latencyGauge.sample((double)query.getDurationTime(), dims);
        return execution.search(query);
    }
}

