/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.search.schema.Schema;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class SchemaInfoConfigurer {
    SchemaInfoConfigurer() {
    }

    static List<Schema> toSchemas(SchemaInfoConfig schemaInfoConfig) {
        return schemaInfoConfig.schema().stream().map(config -> SchemaInfoConfigurer.toSchema(config)).collect(Collectors.toList());
    }

    static Schema toSchema(SchemaInfoConfig.Schema schemaInfoConfig) {
        Schema.Builder builder = new Schema.Builder(schemaInfoConfig.name());
        for (SchemaInfoConfig.Schema.Rankprofile profileConfig : schemaInfoConfig.rankprofile()) {
            RankProfile.Builder profileBuilder = new RankProfile.Builder(profileConfig.name());
            profileBuilder.setHasSummaryFeatures(profileConfig.hasSummaryFeatures());
            profileBuilder.setHasRankFeatures(profileConfig.hasRankFeatures());
            for (SchemaInfoConfig.Schema.Rankprofile.Input inputConfig : profileConfig.input()) {
                profileBuilder.addInput(inputConfig.name(), TensorType.fromSpec((String)inputConfig.type()));
            }
            builder.add(profileBuilder.build());
        }
        for (SchemaInfoConfig.Schema.Summaryclass summaryConfig : schemaInfoConfig.summaryclass()) {
            DocumentSummary.Builder summaryBuilder = new DocumentSummary.Builder(summaryConfig.name());
            for (SchemaInfoConfig.Schema.Summaryclass.Fields field : summaryConfig.fields()) {
                if (field.dynamic()) {
                    summaryBuilder.setDynamic(true);
                }
                summaryBuilder.add(new DocumentSummary.Field(field.name(), field.type()));
            }
            builder.add(summaryBuilder.build());
        }
        return builder.build();
    }

    static Map<String, List<String>> toClusters(QrSearchersConfig config) {
        HashMap<String, List<String>> clusters = new HashMap<String, List<String>>();
        for (int i = 0; i < config.searchcluster().size(); ++i) {
            ArrayList<String> schemas = new ArrayList<String>();
            String clusterName = config.searchcluster(i).name();
            for (int j = 0; j < config.searchcluster(i).searchdef().size(); ++j) {
                schemas.add(config.searchcluster(i).searchdef(j));
            }
            clusters.put(clusterName, schemas);
        }
        return clusters;
    }
}

