/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DeepHitIterator
implements Iterator<Hit> {
    private final boolean ordered;
    private List<Iterator<Hit>> stack;
    private boolean canRemove = false;
    private Iterator<Hit> it = null;
    private Hit next = null;

    public DeepHitIterator(Iterator<Hit> it, boolean ordered) {
        this.ordered = ordered;
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        this.canRemove = false;
        return this.getNext();
    }

    @Override
    public Hit next() throws NoSuchElementException {
        if (this.next == null && !this.getNext()) {
            throw new NoSuchElementException();
        }
        Hit ret = this.next;
        this.next = null;
        this.canRemove = true;
        return ret;
    }

    @Override
    public void remove() throws UnsupportedOperationException, IllegalStateException {
        if (!this.canRemove) {
            throw new IllegalStateException("Can not remove() an element after calling hasNext().");
        }
        this.it.remove();
    }

    private boolean getNext() {
        if (this.next != null) {
            return true;
        }
        if (this.stack == null) {
            this.stack = new ArrayList<Iterator<Hit>>();
        }
        while (true) {
            if (this.it.hasNext()) {
                Hit hit = this.it.next();
                if (hit instanceof HitGroup) {
                    this.stack.add(this.it);
                    if (this.ordered) {
                        this.it = ((HitGroup)hit).iterator();
                        continue;
                    }
                    this.it = ((HitGroup)hit).unorderedIterator();
                    continue;
                }
                this.next = hit;
                return true;
            }
            if (this.stack.isEmpty()) break;
            this.it = this.stack.remove(this.stack.size() - 1);
        }
        return false;
    }
}

