/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class RewritesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "b36521e379f2b10f95a6684e40489ea4";
    public static final String CONFIG_DEF_NAME = "rewrites";
    public static final String CONFIG_DEF_NAMESPACE = "search.query.rewrite";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.query.rewrite", "fsaDict[].name string", "fsaDict[].path file"};
    private final InnerNodeVector<FsaDict> fsaDict;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public RewritesConfig(Builder builder) {
        this(builder, true);
    }

    private RewritesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for rewrites must be initialized: " + builder.__uninitialized);
        }
        this.fsaDict = FsaDict.createVector(builder.fsaDict);
    }

    public List<FsaDict> fsaDict() {
        return this.fsaDict;
    }

    public FsaDict fsaDict(int i) {
        return (FsaDict)((Object)this.fsaDict.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(RewritesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<FsaDict.Builder> fsaDict = new ArrayList<FsaDict.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(RewritesConfig config) {
            for (FsaDict f : config.fsaDict()) {
                this.fsaDict(new FsaDict.Builder(f));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.fsaDict.isEmpty()) {
                this.fsaDict.addAll(__superior.fsaDict);
            }
            return this;
        }

        public Builder fsaDict(FsaDict.Builder __builder) {
            this.fsaDict.add(__builder);
            return this;
        }

        public Builder fsaDict(Consumer<FsaDict.Builder> __func) {
            FsaDict.Builder __inner = new FsaDict.Builder();
            __func.accept(__inner);
            this.fsaDict.add(__inner);
            return this;
        }

        public Builder fsaDict(List<FsaDict.Builder> __builders) {
            this.fsaDict = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return RewritesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return RewritesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return RewritesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public RewritesConfig build() {
            return new RewritesConfig(this);
        }
    }

    public static final class FsaDict
    extends InnerNode {
        private final StringNode name;
        private final FileNode path;

        public FsaDict(Builder builder) {
            this(builder, true);
        }

        private FsaDict(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for rewrites.fsaDict[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.path = builder.path == null ? new FileNode() : new FileNode(builder.path);
        }

        public String name() {
            return this.name.value();
        }

        public FileReference path() {
            return this.path.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(FsaDict newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("fsaDict");
            return changes;
        }

        private static InnerNodeVector<FsaDict> createVector(List<Builder> builders) {
            ArrayList<FsaDict> elems = new ArrayList<FsaDict>();
            for (Builder b : builders) {
                elems.add(new FsaDict(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "path"));
            private String name = null;
            private String path = null;

            public Builder() {
            }

            public Builder(FsaDict config) {
                this.name(config.name());
                this.path(config.path().value());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.path != null) {
                    this.path(__superior.path);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder path(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.path = __value;
                this.__uninitialized.remove("path");
                return this;
            }

            public FsaDict build() {
                return new FsaDict(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

