/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.model;

import com.yahoo.component.provider.FreezableClass;
import com.yahoo.protect.Validator;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Renderer
extends FreezableClass
implements PageElement {
    private String name;
    private String rendererFor;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    public Renderer(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.ensureNotFrozen();
        Validator.ensureNotNull((String)"renderer name", (Object)name);
        this.name = name;
    }

    public String getRendererFor() {
        return this.rendererFor;
    }

    public void setRendererFor(String rendererFor) {
        this.ensureNotFrozen();
        this.rendererFor = rendererFor;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        super.freeze();
        this.parameters = Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public void accept(PageTemplateVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "renderer '" + this.name + "'";
    }
}

