/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.logging;

import com.yahoo.search.Query;
import com.yahoo.search.logging.Logger;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.text.Utf8;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Base64;

public class LoggerEntry {
    private final Long timestamp;
    private final Query query;
    private final ByteBuffer blob;
    private final String track;

    private LoggerEntry(Builder builder) {
        this.timestamp = builder.timestamp;
        this.query = builder.query;
        this.blob = builder.blob;
        this.track = builder.track;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public Query query() {
        return this.query;
    }

    public String queryString() {
        Object queryString = null;
        if (this.query != null && this.query.getHttpRequest() != null && this.query.getHttpRequest().getUri() != null) {
            queryString = this.query.getHttpRequest().getUri().getPath();
            if (this.query.getHttpRequest().getUri().getQuery() != null) {
                queryString = (String)queryString + "?" + this.query.getHttpRequest().getUri().getRawQuery();
            }
        }
        return queryString;
    }

    public ByteBuffer blob() {
        return this.blob;
    }

    public String track() {
        return this.track;
    }

    public String toString() {
        return this.serialize();
    }

    public String serialize() {
        try {
            Slime slime = new Slime();
            Cursor root = slime.setObject();
            root.setLong("timestamp", this.timestamp == null ? 0L : this.timestamp);
            root.setString("query", this.queryString());
            root.setString("blob", Base64.getEncoder().encodeToString(this.blob.array()));
            root.setString("track", this.track());
            return Utf8.toString((byte[])SlimeUtils.toJsonBytes((Slime)slime));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static LoggerEntry deserialize(String content) throws IOException {
        Slime slime = SlimeUtils.jsonToSlime((String)content);
        long timestamp = slime.get().field("timestamp").asLong();
        Query query = new Query(slime.get().field("query").asString());
        String blob = slime.get().field("blob").asString();
        String track = slime.get().field("track").asString();
        return new LoggerEntry(new Builder().timestamp(timestamp).query(query).blob(blob).track(track));
    }

    public static class Builder {
        private final Logger logger;
        private Long timestamp;
        private Query query;
        private ByteBuffer blob;
        private String track = "";

        public Builder() {
            this(entry -> false);
        }

        public Builder(Logger logger) {
            this.logger = logger;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder query(Query query) {
            this.query = query;
            return this;
        }

        public Builder blob(byte[] bytes) {
            this.blob = ByteBuffer.allocate(bytes.length);
            this.blob.put(bytes).limit(this.blob.position()).position(0);
            return this;
        }

        public Builder blob(String blob) {
            byte[] bytes = Utf8.toBytes((String)blob);
            this.blob = ByteBuffer.allocate(bytes.length);
            this.blob.put(bytes);
            return this;
        }

        public Builder track(String track) {
            this.track = track;
            return this;
        }

        public boolean send() {
            return this.logger.send(new LoggerEntry(this));
        }
    }
}

