/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.logging;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class LocalDiskLoggerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "8de8da4d31644a0e80a81745a1edf2ea";
    public static final String CONFIG_DEF_NAME = "local-disk-logger";
    public static final String CONFIG_DEF_NAMESPACE = "search.logging";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.logging", "path string default=/dev/null"};
    private final StringNode path;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LocalDiskLoggerConfig(Builder builder) {
        this(builder, true);
    }

    private LocalDiskLoggerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for local-disk-logger must be initialized: " + builder.__uninitialized);
        }
        this.path = builder.path == null ? new StringNode("/dev/null") : new StringNode(builder.path);
    }

    public String path() {
        return this.path.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LocalDiskLoggerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String path = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LocalDiskLoggerConfig config) {
            this.path(config.path());
        }

        private Builder override(Builder __superior) {
            if (__superior.path != null) {
                this.path(__superior.path);
            }
            return this;
        }

        public Builder path(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.path = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LocalDiskLoggerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LocalDiskLoggerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LocalDiskLoggerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LocalDiskLoggerConfig build() {
            return new LocalDiskLoggerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

