/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.FunctionNode;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.MathACosFunction;
import com.yahoo.search.grouping.request.MathACosHFunction;
import com.yahoo.search.grouping.request.MathASinFunction;
import com.yahoo.search.grouping.request.MathASinHFunction;
import com.yahoo.search.grouping.request.MathATanFunction;
import com.yahoo.search.grouping.request.MathATanHFunction;
import com.yahoo.search.grouping.request.MathCbrtFunction;
import com.yahoo.search.grouping.request.MathCosFunction;
import com.yahoo.search.grouping.request.MathCosHFunction;
import com.yahoo.search.grouping.request.MathExpFunction;
import com.yahoo.search.grouping.request.MathFloorFunction;
import com.yahoo.search.grouping.request.MathHypotFunction;
import com.yahoo.search.grouping.request.MathLog10Function;
import com.yahoo.search.grouping.request.MathLog1pFunction;
import com.yahoo.search.grouping.request.MathLogFunction;
import com.yahoo.search.grouping.request.MathPowFunction;
import com.yahoo.search.grouping.request.MathSinFunction;
import com.yahoo.search.grouping.request.MathSinHFunction;
import com.yahoo.search.grouping.request.MathSqrtFunction;
import com.yahoo.search.grouping.request.MathTanFunction;
import com.yahoo.search.grouping.request.MathTanHFunction;

public abstract class MathFunctions {
    public static FunctionNode newInstance(Function type, GroupingExpression x, GroupingExpression y) {
        switch (type) {
            case EXP: {
                return new MathExpFunction(x);
            }
            case POW: {
                return new MathPowFunction(x, y);
            }
            case LOG: {
                return new MathLogFunction(x);
            }
            case LOG1P: {
                return new MathLog1pFunction(x);
            }
            case LOG10: {
                return new MathLog10Function(x);
            }
            case SIN: {
                return new MathSinFunction(x);
            }
            case ASIN: {
                return new MathASinFunction(x);
            }
            case COS: {
                return new MathCosFunction(x);
            }
            case ACOS: {
                return new MathACosFunction(x);
            }
            case TAN: {
                return new MathTanFunction(x);
            }
            case ATAN: {
                return new MathATanFunction(x);
            }
            case SQRT: {
                return new MathSqrtFunction(x);
            }
            case SINH: {
                return new MathSinHFunction(x);
            }
            case ASINH: {
                return new MathASinHFunction(x);
            }
            case COSH: {
                return new MathCosHFunction(x);
            }
            case ACOSH: {
                return new MathACosHFunction(x);
            }
            case TANH: {
                return new MathTanHFunction(x);
            }
            case ATANH: {
                return new MathATanHFunction(x);
            }
            case CBRT: {
                return new MathCbrtFunction(x);
            }
            case HYPOT: {
                return new MathHypotFunction(x, y);
            }
            case FLOOR: {
                return new MathFloorFunction(x);
            }
        }
        return null;
    }

    public static enum Function {
        EXP,
        POW,
        LOG,
        LOG1P,
        LOG10,
        SIN,
        ASIN,
        COS,
        ACOS,
        TAN,
        ATAN,
        SQRT,
        SINH,
        ASINH,
        COSH,
        ACOSH,
        TANH,
        ATANH,
        CBRT,
        HYPOT,
        FLOOR;


        static Function create(int tid) {
            for (Function p : Function.values()) {
                if (tid != p.ordinal()) continue;
                return p;
            }
            return null;
        }
    }
}

