/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.GroupingExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class FunctionNode
extends GroupingExpression
implements Iterable<GroupingExpression> {
    private final List<GroupingExpression> args = new ArrayList<GroupingExpression>();

    protected FunctionNode(String image, String label, Integer level, List<GroupingExpression> args) {
        super(image + "(" + FunctionNode.asString(args) + ")", label, level);
        this.args.addAll(args);
    }

    public int getNumArgs() {
        return this.args.size();
    }

    public GroupingExpression getArg(int i) {
        return this.args.get(i);
    }

    protected List<GroupingExpression> args() {
        return this.args;
    }

    @Override
    public Iterator<GroupingExpression> iterator() {
        return Collections.unmodifiableList(this.args).iterator();
    }

    @Override
    public void resolveLevel(int level) {
        super.resolveLevel(level);
        for (GroupingExpression arg : this.args) {
            arg.resolveLevel(level);
        }
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        super.visit(visitor);
        for (GroupingExpression arg : this.args) {
            arg.visit(visitor);
        }
    }

    protected static <T> List<T> asList(T arg1, T ... argN) {
        return FunctionNode.asList(Arrays.asList(arg1), Arrays.asList(argN));
    }

    protected static <T> List<T> asList(T arg1, T arg2, T ... argN) {
        return FunctionNode.asList(Arrays.asList(arg1, arg2), Arrays.asList(argN));
    }

    protected static <T> List<T> asList(List<T> foo, List<T> bar) {
        LinkedList<T> ret = new LinkedList<T>(foo);
        ret.addAll(bar);
        return ret;
    }
}

