/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.google.common.math.Quantiles;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchGroups;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SearchGroupsImpl
implements SearchGroups {
    private final Map<Integer, Group> groups;
    private final double minActivedocsPercentage;

    public SearchGroupsImpl(Map<Integer, Group> groups, double minActivedocsPercentage) {
        this.groups = Map.copyOf(groups);
        this.minActivedocsPercentage = minActivedocsPercentage;
    }

    @Override
    public Group get(int id) {
        return this.groups.get(id);
    }

    @Override
    public Set<Integer> keys() {
        return this.groups.keySet();
    }

    @Override
    public Collection<Group> groups() {
        return this.groups.values();
    }

    @Override
    public int size() {
        return this.groups.size();
    }

    @Override
    public boolean isPartialGroupCoverageSufficient(Collection<Node> nodes) {
        if (this.size() == 1) {
            return true;
        }
        long activeDocuments = nodes.stream().mapToLong(Node::getActiveDocuments).sum();
        return this.isGroupCoverageSufficient(activeDocuments, this.medianDocumentsPerGroup());
    }

    public boolean isGroupCoverageSufficient(long activeDocuments, long medianDocuments) {
        if (medianDocuments <= 0L) {
            return true;
        }
        double documentCoverage = 100.0 * (double)activeDocuments / (double)medianDocuments;
        return documentCoverage >= this.minActivedocsPercentage;
    }

    public long medianDocumentsPerGroup() {
        if (this.isEmpty()) {
            return 0L;
        }
        List activeDocuments = this.groups().stream().map(Group::activeDocuments).collect(Collectors.toList());
        return (long)Quantiles.median().compute(activeDocuments);
    }
}

