/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.dispatch.rpc.Client;
import com.yahoo.search.dispatch.rpc.CompressPayload;

public class CompressService
implements CompressPayload {
    public static final CompoundName dispatchCompression = new CompoundName("dispatch.compression");
    private final Compressor compressor = new Compressor(CompressionType.LZ4, 5, 0.95, 256);

    @Override
    public Compressor.Compression compress(Query query, byte[] payload) {
        CompressionType compression = CompressionType.valueOf((String)query.properties().getString(dispatchCompression, "LZ4").toUpperCase());
        return this.compressor.compress(compression, payload);
    }

    @Override
    public byte[] decompress(Client.ProtobufResponse response) {
        CompressionType compression = CompressionType.valueOf((byte)response.compression());
        return this.compressor.decompress(response.compressedPayload(), compression, response.uncompressedSize());
    }

    Compressor compressor() {
        return this.compressor;
    }
}

