/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.collections.Pair;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchGroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SearchPath {
    private static final Pattern NODE_WILDCARD = Pattern.compile("^\\*?(?:,|$|/$)");
    private static final Pattern NODE_RANGE = Pattern.compile("^\\[(\\d+),(\\d+)>(?:,|$)");
    private final List<Selection> nodes;
    private final List<Selection> groups;
    private static final Random random = new Random();

    private SearchPath(List<Selection> nodes, List<Selection> groups) {
        this.nodes = nodes;
        this.groups = groups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SearchPath.selectionToString(sb, this.nodes);
        if (!this.groups.isEmpty()) {
            sb.append('/');
            SearchPath.selectionToString(sb, this.groups);
        }
        return sb.toString();
    }

    private List<Node> mapToNodes(SearchGroups cluster) {
        if (cluster.isEmpty()) {
            return List.of();
        }
        Group selectedGroup = this.selectGroup(cluster);
        if (this.nodes.isEmpty()) {
            return selectedGroup.nodes();
        }
        List<Node> groupNodes = selectedGroup.nodes();
        HashSet<Integer> wanted = new HashSet<Integer>();
        int max = groupNodes.size();
        for (Selection node : this.nodes) {
            wanted.addAll(node.matches(max));
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator iterator = wanted.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            ret.add(groupNodes.get(idx));
        }
        return ret;
    }

    private boolean isEmpty() {
        return this.nodes.isEmpty() && this.groups.isEmpty();
    }

    private Group selectRandomGroupWithSufficientCoverage(SearchGroups cluster, List<Integer> groupIds) {
        while (groupIds.size() > 1) {
            int index = random.nextInt(groupIds.size());
            int groupId = groupIds.get(index);
            Group group = cluster.get(groupId);
            if (group != null) {
                if (group.hasSufficientCoverage()) {
                    return group;
                }
                groupIds.remove(index);
                continue;
            }
            throw new InvalidSearchPathException("Invalid search path: Cluster does not have " + (groupId + 1) + " groups");
        }
        return cluster.get(groupIds.get(0));
    }

    private Group selectGroup(SearchGroups cluster) {
        if (!this.groups.isEmpty()) {
            ArrayList<Integer> potentialGroups = new ArrayList<Integer>();
            for (Selection groupSelection : this.groups) {
                for (int group = groupSelection.from; group < groupSelection.to; ++group) {
                    potentialGroups.add(group);
                }
            }
            return this.selectRandomGroupWithSufficientCoverage(cluster, potentialGroups);
        }
        return this.selectRandomGroupWithSufficientCoverage(cluster, new ArrayList<Integer>(cluster.keys()));
    }

    public static List<Node> selectNodes(String searchPath, SearchGroups cluster) {
        Optional<SearchPath> sp = SearchPath.fromString(searchPath);
        if (sp.isPresent()) {
            return sp.get().mapToNodes(cluster);
        }
        return List.of();
    }

    static Optional<SearchPath> fromString(String path) {
        if (path == null || path.isEmpty()) {
            return Optional.empty();
        }
        if (path.indexOf(59) >= 0) {
            return Optional.empty();
        }
        try {
            SearchPath sp = SearchPath.parseElement(path);
            if (sp.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(sp);
        }
        catch (InvalidSearchPathException | NumberFormatException e) {
            throw new InvalidSearchPathException("Invalid search path '" + path + "'", e);
        }
    }

    private static SearchPath parseElement(String element) {
        Pair<String, String> nodesAndGroups = SearchPath.halveAt('/', element);
        List<Selection> nodes = SearchPath.parseSelection((String)nodesAndGroups.getFirst());
        List<Selection> groups = SearchPath.parseSelection((String)nodesAndGroups.getSecond());
        return new SearchPath(nodes, groups);
    }

    private static List<Selection> parseSelection(String nodes) {
        ArrayList<Selection> ret = new ArrayList<Selection>();
        while (nodes.length() > 0) {
            if (nodes.startsWith("[")) {
                nodes = SearchPath.parseNodeRange(nodes, ret);
                continue;
            }
            if (SearchPath.isWildcard(nodes)) {
                return Collections.emptyList();
            }
            nodes = SearchPath.parseNodeNum(nodes, ret);
        }
        return ret;
    }

    private static boolean isWildcard(String node) {
        return NODE_WILDCARD.matcher(node).lookingAt();
    }

    private static String parseNodeRange(String nodes, List<Selection> into) {
        Matcher m = NODE_RANGE.matcher(nodes);
        if (m.find()) {
            int end;
            String ret = nodes.substring(m.end());
            int start = Integer.parseInt(m.group(1));
            if (start > (end = Integer.parseInt(m.group(2)))) {
                throw new InvalidSearchPathException("Invalid range");
            }
            into.add(new Selection(start, end));
            return ret;
        }
        throw new InvalidSearchPathException("Invalid range expression");
    }

    private static String parseNodeNum(String nodes, List<Selection> into) {
        Pair<String, String> numAndRest = SearchPath.halveAt(',', nodes);
        int nodeNum = Integer.parseInt((String)numAndRest.getFirst());
        into.add(new Selection(nodeNum, nodeNum + 1));
        return (String)numAndRest.getSecond();
    }

    private static Pair<String, String> halveAt(char divider, String string) {
        int pos = string.indexOf(divider);
        if (pos >= 0) {
            return new Pair((Object)string.substring(0, pos), (Object)string.substring(pos + 1));
        }
        return new Pair((Object)string, (Object)"");
    }

    private static void selectionToString(StringBuilder sb, List<Selection> nodes) {
        boolean first = true;
        for (Selection p : nodes) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(p.toString());
        }
    }

    private static class Selection {
        private final int from;
        private final int to;

        Selection(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public Collection<Integer> matches(int max) {
            if (this.from >= max) {
                return Collections.emptyList();
            }
            int end = Math.min(this.to, max);
            return IntStream.range(this.from, end).boxed().collect(Collectors.toList());
        }

        public String toString() {
            if (this.from + 1 == this.to) {
                return Integer.toString(this.from);
            }
            return "[" + this.from + "," + this.to + ">";
        }
    }

    public static class InvalidSearchPathException
    extends IllegalArgumentException {
        public InvalidSearchPathException(String message) {
            super(message);
        }

        public InvalidSearchPathException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

