/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.engine.Match;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.ProductionRule;

public class ReplacingProductionRule
extends ProductionRule {
    @Override
    public void produce(RuleEvaluation e) {
        this.removeNonreferencedMatches(e);
        if (e.getTraceLevel() >= 5) {
            e.trace(5, "Removed terms to get '" + e.getEvaluation().getQuery().getModel().getQueryTree().getRoot() + "', will add terms");
        }
        super.produce(e);
    }

    private void removeNonreferencedMatches(RuleEvaluation e) {
        int itemCount = e.getEvaluation().getQuerySize();
        for (int i = e.getNonreferencedMatchCount() - 1; i >= 0 && (this.getProduction().getTermCount() != 0 || itemCount != 1); --itemCount, --i) {
            Match match = e.getNonreferencedMatch(i);
            match.getItem().getParent().removeItem(match.getPosition());
        }
    }

    @Override
    protected String getSymbol() {
        return "->";
    }
}

