/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.semantics.engine.Match;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReferencedMatches {
    private final String contextName;
    private final List<Match> matches = new ArrayList<Match>(1);

    public ReferencedMatches(String contextName) {
        this.contextName = contextName;
    }

    public void addMatch(Match match) {
        this.matches.add(match);
    }

    public String getContextName() {
        return this.contextName;
    }

    public Iterator<Match> matchIterator() {
        return this.matches.iterator();
    }

    public Item toItem(String label) {
        if (this.matches.size() == 0) {
            return null;
        }
        if (this.matches.size() == 1) {
            return this.matches.get(0).toItem(label);
        }
        PhraseItem phrase = new PhraseItem();
        phrase.setIndexName(label);
        Iterator<Match> i = this.matches.iterator();
        while (i.hasNext()) {
            phrase.addItem(i.next().toItem(label));
        }
        return phrase;
    }
}

