/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics;

import com.yahoo.io.IOUtils;
import com.yahoo.language.Linguistics;
import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.prelude.semantics.parser.ParseException;
import com.yahoo.prelude.semantics.parser.SemanticsParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RuleImporter {
    private final SemanticRulesConfig config;
    private final boolean ignoreAutomatas;
    private final boolean ignoreIncludes;
    private Linguistics linguistics;

    public RuleImporter(Linguistics linguistics) {
        this(null, false, linguistics);
    }

    public RuleImporter(SemanticRulesConfig config, Linguistics linguistics) {
        this(config, false, linguistics);
    }

    public RuleImporter(boolean ignoreAutomatas, Linguistics linguistics) {
        this(null, ignoreAutomatas, linguistics);
    }

    public RuleImporter(boolean ignoreAutomatas, boolean ignoreIncludes, Linguistics linguistics) {
        this(null, ignoreAutomatas, ignoreIncludes, linguistics);
    }

    public RuleImporter(SemanticRulesConfig config, boolean ignoreAutomatas, Linguistics linguistics) {
        this(config, ignoreAutomatas, false, linguistics);
    }

    public RuleImporter(SemanticRulesConfig config, boolean ignoreAutomatas, boolean ignoreIncludes, Linguistics linguistics) {
        this.config = config;
        this.ignoreAutomatas = ignoreAutomatas;
        this.ignoreIncludes = ignoreIncludes;
        this.linguistics = linguistics;
    }

    public RuleBase importFile(String fileName) throws IOException, ParseException {
        return this.importFile(fileName, null);
    }

    public RuleBase importFile(String fileName, String automataFile) throws IOException, ParseException {
        RuleBase ruleBase = this.privateImportFile(fileName, automataFile);
        ruleBase.initialize();
        return ruleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleBase privateImportFile(String fileName, String automataFile) throws IOException, ParseException {
        BufferedReader reader = null;
        try {
            reader = IOUtils.createReader((String)fileName, (String)"utf-8");
            File file = new File(fileName);
            String absoluteFileName = file.getAbsolutePath();
            RuleBase ruleBase = new RuleBase(RuleImporter.stripLastName(file.getName()));
            this.privateImportFromReader(reader, absoluteFileName, automataFile, ruleBase);
            RuleBase ruleBase2 = ruleBase;
            return ruleBase2;
        }
        finally {
            IOUtils.closeReader((Reader)reader);
        }
    }

    public List<RuleBase> importDir(String ruleBaseDir) throws IOException, ParseException {
        File ruleBaseDirFile = new File(ruleBaseDir);
        if (!ruleBaseDirFile.exists()) {
            throw new IOException("Rule base dir '" + ruleBaseDirFile.getAbsolutePath() + "' does not exist");
        }
        Object[] files = ruleBaseDirFile.listFiles();
        Arrays.sort(files);
        ArrayList<RuleBase> ruleBases = new ArrayList<RuleBase>();
        for (Object file : files) {
            if (!((File)file).getName().endsWith(".sr")) continue;
            RuleBase base = this.importFile(((File)file).getAbsolutePath());
            ruleBases.add(base);
        }
        return ruleBases;
    }

    public void include(String ruleBaseName, RuleBase ruleBase) throws IOException, ParseException {
        if (this.ignoreIncludes) {
            return;
        }
        RuleBase include = this.config == null ? this.privateImportFromDirectory(ruleBaseName, ruleBase) : this.privateImportFromConfig(ruleBaseName);
        ruleBase.include(include);
    }

    private RuleBase privateImportFromDirectory(String ruleBaseName, RuleBase ruleBase) throws IOException, ParseException {
        File importFile;
        String includeDir = new File(ruleBase.getSource()).getParentFile().getAbsolutePath();
        if (!((String)ruleBaseName).endsWith(".sr")) {
            ruleBaseName = (String)ruleBaseName + ".sr";
        }
        if (!(importFile = new File(includeDir, (String)ruleBaseName)).exists()) {
            throw new IOException("No file named '" + RuleImporter.shortenPath(importFile.getPath()) + "'");
        }
        return this.privateImportFile(importFile.getPath(), null);
    }

    private RuleBase privateImportFromConfig(String ruleBaseName) throws ParseException {
        SemanticRulesConfig.Rulebase ruleBaseConfig = this.findRuleBaseConfig(this.config, ruleBaseName);
        if (ruleBaseConfig == null) {
            ruleBaseConfig = this.findRuleBaseConfig(this.config, RuleImporter.stripLastName(ruleBaseName));
        }
        if (ruleBaseConfig == null) {
            throw new ParseException("Could not find included rule base '" + ruleBaseName + "'");
        }
        return this.privateImportConfig(ruleBaseConfig);
    }

    private SemanticRulesConfig.Rulebase findRuleBaseConfig(SemanticRulesConfig config, String ruleBaseName) {
        for (SemanticRulesConfig.Rulebase aRulebase : config.rulebase()) {
            SemanticRulesConfig.Rulebase ruleBaseConfig = aRulebase;
            if (!ruleBaseConfig.name().equals(ruleBaseName)) continue;
            return ruleBaseConfig;
        }
        return null;
    }

    public void setAutomata(RuleBase base, String automata) {
        if (this.ignoreAutomatas) {
            base.setUsesAutomata(true);
        } else {
            base.setAutomataFile(automata);
        }
    }

    static String stripLastName(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, lastDotIndex);
    }

    public RuleBase importString(String string, String automataFile) throws IOException, ParseException {
        return this.importString(string, automataFile, null, null);
    }

    public RuleBase importString(String string, String automataFile, String sourceName) throws IOException, ParseException {
        return this.importString(string, automataFile, sourceName, null);
    }

    public RuleBase importString(String string, String automataFile, RuleBase ruleBase) throws IOException, ParseException {
        return this.importString(string, automataFile, null, ruleBase);
    }

    public RuleBase importString(String string, String automataFile, String sourceName, RuleBase ruleBase) throws IOException, ParseException {
        return this.importFromReader(new StringReader(string), sourceName, automataFile, ruleBase);
    }

    public RuleBase importConfig(SemanticRulesConfig.Rulebase ruleBaseConfig) throws IOException, ParseException {
        RuleBase ruleBase = this.privateImportConfig(ruleBaseConfig);
        ruleBase.initialize();
        return ruleBase;
    }

    public RuleBase privateImportConfig(SemanticRulesConfig.Rulebase ruleBaseConfig) throws ParseException {
        if (this.config == null) {
            throw new IllegalStateException("Must initialize with config if importing from config");
        }
        RuleBase ruleBase = new RuleBase(ruleBaseConfig.name());
        return this.privateImportFromReader(new StringReader(ruleBaseConfig.rules()), "semantic-rules.cfg", ruleBaseConfig.automata(), ruleBase);
    }

    public RuleBase importFromReader(Reader reader, String sourceInfo, String automataFile) throws ParseException {
        return this.importFromReader(reader, sourceInfo, automataFile, null);
    }

    public RuleBase importFromReader(Reader reader, String sourceName, String automataFile, RuleBase ruleBase) throws ParseException {
        ruleBase = this.privateImportFromReader(reader, sourceName, automataFile, ruleBase);
        ruleBase.initialize();
        return ruleBase;
    }

    public RuleBase privateImportFromReader(Reader reader, String sourceName, String automataFile, RuleBase ruleBase) throws ParseException {
        try {
            if (ruleBase == null) {
                ruleBase = new RuleBase(sourceName == null ? "anonymous" : sourceName);
            }
            ruleBase.setSource(sourceName.replace('\\', '/'));
            new SemanticsParser(reader, this.linguistics).semanticRules(ruleBase, this);
            if (automataFile != null && !automataFile.isEmpty()) {
                ruleBase.setAutomataFile(automataFile.replace('\\', '/'));
            }
            return ruleBase;
        }
        catch (Throwable t) {
            ParseException p = new ParseException("Could not parse '" + RuleImporter.shortenPath(sourceName) + "'");
            p.initCause(t);
            throw p;
        }
    }

    private static String shortenPath(String path) {
        int rulesIndex = path.indexOf("rules/");
        if (rulesIndex < 0) {
            return path;
        }
        return path.substring(rulesIndex);
    }
}

