/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.StemList;
import com.yahoo.language.process.StemMode;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Highlight;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

@After(value={"unblendedResult", "TermOrderRelaxation"})
@Provides(value={"Stemming"})
public class StemmingSearcher
extends Searcher {
    public static final String STEMMING = "Stemming";
    public static final CompoundName DISABLE = new CompoundName("nostemming");
    private final Linguistics linguistics;

    public StemmingSearcher(Linguistics linguistics) {
        this.linguistics = linguistics;
    }

    @Inject
    public StemmingSearcher(ComponentId id, Linguistics linguistics) {
        super(id);
        this.linguistics = linguistics;
    }

    @Override
    public Result search(Query query, Execution execution) {
        if (query.properties().getBoolean(DISABLE)) {
            return execution.search(query);
        }
        IndexFacts.Session indexFacts = execution.context().getIndexFacts().newSession(query);
        Item newRoot = this.replaceTerms(query, indexFacts);
        query.getModel().getQueryTree().setRoot(newRoot);
        query.trace(this.getFunctionName(), true, 2);
        Highlight highlight = query.getPresentation().getHighlight();
        if (highlight != null) {
            Set<String> highlightFields = highlight.getHighlightItems().keySet();
            for (String field : highlightFields) {
                StemMode stemMode = indexFacts.getIndex(field).getStemMode();
                if (stemMode == StemMode.NONE) continue;
                StemContext context = new StemContext();
                context.language = Language.ENGLISH;
                context.indexFacts = indexFacts;
                Item newHighlight = this.scan(highlight.getHighlightItems().get(field), context);
                highlight.getHighlightItems().put(field, (AndItem)newHighlight);
            }
        }
        return execution.search(query);
    }

    public String getFunctionName() {
        return STEMMING;
    }

    private Item replaceTerms(Query q, IndexFacts.Session indexFacts) {
        Language language = q.getModel().getParsingLanguage();
        if (language == Language.UNKNOWN) {
            return q.getModel().getQueryTree().getRoot();
        }
        StemContext context = new StemContext();
        context.isCJK = language.isCjk();
        context.language = language;
        context.indexFacts = indexFacts;
        context.reverseConnectivity = this.createReverseConnectivities(q.getModel().getQueryTree().getRoot());
        q.trace("Stemming with language=" + language, 3);
        return this.scan(q.getModel().getQueryTree().getRoot(), context);
    }

    private Map<Item, TaggableItem> createReverseConnectivities(Item root) {
        return this.populateReverseConnectivityMap(root, new IdentityHashMap<Item, TaggableItem>());
    }

    private Map<Item, TaggableItem> populateReverseConnectivityMap(Item root, Map<Item, TaggableItem> reverseConnectivity) {
        TaggableItem asTaggable;
        Item connectsTo;
        if (root instanceof TaggableItem && (connectsTo = (asTaggable = (TaggableItem)((Object)root)).getConnectedItem()) != null) {
            reverseConnectivity.put(connectsTo, asTaggable);
        }
        if (root instanceof CompositeItem && !(root instanceof BlockItem)) {
            CompositeItem c = (CompositeItem)root;
            ListIterator<Item> i = c.getItemIterator();
            while (i.hasNext()) {
                Item item = (Item)i.next();
                this.populateReverseConnectivityMap(item, reverseConnectivity);
            }
        }
        return reverseConnectivity;
    }

    private Item scan(Item item, StemContext context) {
        if (item == null) {
            return null;
        }
        boolean old = context.insidePhrase;
        if (item instanceof PhraseItem || item instanceof PhraseSegmentItem) {
            context.insidePhrase = true;
        }
        if (item instanceof BlockItem) {
            item = this.checkBlock((BlockItem)((Object)item), context);
        } else if (item instanceof CompositeItem) {
            CompositeItem comp = (CompositeItem)item;
            ListIterator<Item> i = comp.getItemIterator();
            while (i.hasNext()) {
                Item transformed;
                Item original = i.next();
                if (original == (transformed = this.scan(original, context))) continue;
                i.set(transformed);
            }
        }
        context.insidePhrase = old;
        return item;
    }

    private Item checkBlock(BlockItem b, StemContext context) {
        Index index;
        StemMode stemMode;
        if (b instanceof PrefixItem || !b.isWords()) {
            return (Item)((Object)b);
        }
        if (b.isFromQuery() && !b.isStemmed() && (stemMode = (index = context.indexFacts.getIndex(b.getIndexName())).getStemMode()) != StemMode.NONE) {
            return this.stem(b, context, index);
        }
        return (Item)((Object)b);
    }

    private Substring getOffsets(BlockItem b) {
        if (b instanceof TermItem) {
            return b.getOrigin();
        }
        if (b instanceof CompositeItem) {
            Item i = ((CompositeItem)((Object)b)).getItem(0);
            if (i instanceof TermItem) {
                return ((TermItem)i).getOrigin();
            }
            this.getLogger().log(Level.WARNING, "Weird, BlockItem '" + b + "' was a composite containing " + i.getClass().getName() + ", expected TermItem.");
        }
        return null;
    }

    private Item stem(BlockItem current, StemContext context, Index index) {
        Item blockAsItem = (Item)((Object)current);
        List segments = this.linguistics.getStemmer().stem(current.stringValue(), index.getStemMode(), context.language);
        String indexName = current.getIndexName();
        Substring substring = this.getOffsets(current);
        if (segments.size() == 1) {
            this.getLogger().log(Level.FINE, () -> "Stem '" + current.stringValue() + "' mode " + index.getStemMode() + " and language '" + context.language + "' -> '" + segments.get(0) + "'");
            TaggableItem w = this.singleWordSegment(current, (StemList)segments.get(0), index, substring, context.insidePhrase);
            this.setMetaData(current, context.reverseConnectivity, w);
            return (Item)((Object)w);
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Stem '").append(current.stringValue());
            buf.append("' mode ").append(index.getStemMode());
            buf.append(" and language '").append(context.language).append("' ->");
            for (StemList segment : segments) {
                buf.append(" '").append(segment).append("'");
            }
            this.getLogger().log(Level.FINE, buf.toString());
        }
        CompositeItem composite = context.isCJK ? this.chooseCompositeForCJK(current, ((Item)((Object)current)).getParent(), indexName) : this.chooseComposite(current, ((Item)((Object)current)).getParent(), indexName);
        for (StemList segment : segments) {
            this.getLogger().log(Level.FINE, () -> "Stem to multiple segments '" + segment + "'");
            TaggableItem w = this.singleWordSegment(current, segment, index, substring, context.insidePhrase);
            if (composite instanceof AndSegmentItem) {
                this.setSignificance(w, current);
            }
            composite.addItem((Item)((Object)w));
        }
        if (composite instanceof AndSegmentItem) {
            this.andSegmentConnectivity(current, context.reverseConnectivity, composite);
        }
        this.copyAttributes(blockAsItem, composite);
        composite.lock();
        if (composite instanceof PhraseSegmentItem) {
            PhraseSegmentItem replacement = (PhraseSegmentItem)composite;
            this.setSignificance(replacement, current);
            this.phraseSegmentConnectivity(current, context.reverseConnectivity, replacement);
        }
        return composite;
    }

    private void phraseSegmentConnectivity(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, PhraseSegmentItem replacement) {
        Connectivity c = this.getConnectivity(current);
        if (c != null) {
            replacement.setConnectivity(c.word, c.value);
            reverseConnectivity.put(c.word, replacement);
        }
        this.setConnectivity(current, reverseConnectivity, replacement);
    }

    private void andSegmentConnectivity(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, CompositeItem composite) {
        TaggableItem w;
        Connectivity connectivity = this.getConnectivity(current);
        if (connectivity != null && (w = this.lastWord(composite)) != null) {
            w.setConnectivity(connectivity.word, connectivity.value);
            reverseConnectivity.put(connectivity.word, w);
        }
        if ((w = this.firstWord(composite)) != null) {
            this.setConnectivity(current, reverseConnectivity, (Item)((Object)w));
        }
    }

    private Connectivity getConnectivity(BlockItem current) {
        if (!(current instanceof TaggableItem)) {
            return null;
        }
        TaggableItem t = (TaggableItem)((Object)current);
        if (t.getConnectedItem() == null) {
            return null;
        }
        return new Connectivity(t.getConnectedItem(), t.getConnectivity());
    }

    private TaggableItem firstWord(CompositeItem composite) {
        int l = composite.getItemCount();
        if (l == 0) {
            return null;
        }
        return (TaggableItem)((Object)composite.getItem(0));
    }

    private TaggableItem lastWord(CompositeItem composite) {
        int l = composite.getItemCount();
        if (l == 0) {
            return null;
        }
        return (TaggableItem)((Object)composite.getItem(l - 1));
    }

    private TaggableItem singleWordSegment(BlockItem current, StemList segment, Index index, Substring substring, boolean insidePhrase) {
        String indexName = current.getIndexName();
        if (!insidePhrase && (index.getLiteralBoost() || index.getStemMode() == StemMode.ALL)) {
            ArrayList<WordAlternativesItem.Alternative> terms = new ArrayList<WordAlternativesItem.Alternative>(segment.size() + 1);
            terms.add(new WordAlternativesItem.Alternative(current.stringValue(), 1.0));
            for (String term : segment) {
                terms.add(new WordAlternativesItem.Alternative(term, 0.7));
            }
            WordAlternativesItem alternatives = new WordAlternativesItem(indexName, current.isFromQuery(), substring, terms);
            if (alternatives.getAlternatives().size() > 1) {
                return alternatives;
            }
        }
        WordItem first = this.singleStemSegment((Item)((Object)current), segment.get(0), indexName, substring);
        return first;
    }

    private void setMetaData(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, TaggableItem replacement) {
        this.copyAttributes((Item)((Object)current), (Item)((Object)replacement));
        this.setSignificance(replacement, current);
        Connectivity c = this.getConnectivity(current);
        if (c != null) {
            replacement.setConnectivity(c.word, c.value);
            reverseConnectivity.put(c.word, replacement);
        }
        this.setConnectivity(current, reverseConnectivity, (Item)((Object)replacement));
    }

    private WordItem singleStemSegment(Item blockAsItem, String stem, String indexName, Substring substring) {
        WordItem replacement = new WordItem(stem, indexName, true, substring);
        replacement.setStemmed(true);
        this.copyAttributes(blockAsItem, replacement);
        return replacement;
    }

    private void setConnectivity(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, Item replacement) {
        TaggableItem connectedTo;
        if (reverseConnectivity != null && !reverseConnectivity.isEmpty() && (connectedTo = reverseConnectivity.get(current)) != null) {
            double connectivity = connectedTo.getConnectivity();
            connectedTo.setConnectivity(replacement, connectivity);
        }
    }

    private CompositeItem chooseComposite(BlockItem current, CompositeItem parent, String indexName) {
        if (parent instanceof PhraseItem || current instanceof PhraseSegmentItem) {
            return this.createPhraseSegment(current, indexName);
        }
        return this.createAndSegment(current);
    }

    private CompositeItem chooseCompositeForCJK(BlockItem current, CompositeItem parent, String indexName) {
        if (current.getSegmentingRule() == SegmentingRule.LANGUAGE_DEFAULT) {
            return this.chooseComposite(current, parent, indexName);
        }
        switch (current.getSegmentingRule()) {
            case PHRASE: {
                return this.createPhraseSegment(current, indexName);
            }
            case BOOLEAN_AND: {
                return this.createAndSegment(current);
            }
        }
        throw new IllegalArgumentException("Unknown segmenting rule: " + current.getSegmentingRule() + ". This is a bug in Vespa, as the implementation has gotten out of sync. Please create an issue.");
    }

    private AndSegmentItem createAndSegment(BlockItem current) {
        return new AndSegmentItem(current.stringValue(), true, true);
    }

    private CompositeItem createPhraseSegment(BlockItem current, String indexName) {
        PhraseSegmentItem composite = new PhraseSegmentItem(current.getRawWord(), current.stringValue(), true, true);
        ((CompositeItem)composite).setIndexName(indexName);
        return composite;
    }

    private void copyAttributes(Item blockAsItem, Item replacement) {
        this.copyWeight(blockAsItem, replacement);
        replacement.setCreator(blockAsItem.getCreator());
        replacement.setRanked(blockAsItem.isRanked());
        replacement.setPositionData(blockAsItem.usePositionData());
    }

    private void copyWeight(Item block, Item replacement) {
        int weight = this.getWeight(block);
        this.setWeight(replacement, weight);
    }

    private int getWeight(Item block) {
        if (block instanceof AndSegmentItem && ((AndSegmentItem)block).getItemCount() > 0) {
            return ((AndSegmentItem)block).getItem(0).getWeight();
        }
        return block.getWeight();
    }

    private void setWeight(Item replacement, int weight) {
        if (replacement instanceof AndSegmentItem) {
            ListIterator<Item> i = ((AndSegmentItem)replacement).getItemIterator();
            while (i.hasNext()) {
                ((Item)i.next()).setWeight(weight);
            }
        } else {
            replacement.setWeight(weight);
        }
    }

    private void setSignificance(PhraseSegmentItem target, BlockItem original) {
        if (this.hasExplicitSignificance(original)) {
            target.setSignificance(this.getSignificance(original));
        }
    }

    private void setSignificance(TaggableItem target, BlockItem original) {
        if (this.hasExplicitSignificance(original)) {
            target.setSignificance(this.getSignificance(original));
        }
    }

    private boolean hasExplicitSignificance(BlockItem blockItem) {
        if (blockItem instanceof TermItem) {
            return ((TermItem)blockItem).hasExplicitSignificance();
        }
        if (blockItem instanceof PhraseSegmentItem) {
            return ((PhraseSegmentItem)blockItem).hasExplicitSignificance();
        }
        return false;
    }

    private double getSignificance(BlockItem blockItem) {
        if (blockItem instanceof TermItem) {
            return ((TermItem)blockItem).getSignificance();
        }
        return ((PhraseSegmentItem)blockItem).getSignificance();
    }

    private static class StemContext {
        public boolean isCJK = false;
        public boolean insidePhrase = false;
        public Language language = null;
        public IndexFacts.Session indexFacts = null;
        public Map<Item, TaggableItem> reverseConnectivity = null;

        private StemContext() {
        }
    }

    private static class Connectivity {
        public final Item word;
        public final double value;

        public Connectivity(Item connectedItem, double connectivity) {
            this.word = connectedItem;
            this.value = connectivity;
        }
    }
}

