/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.Schema;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import java.util.HashSet;
import java.util.Set;

@After(value={"ExternalYql"})
public class FieldFiller
extends Searcher {
    private final SchemaInfo schemaInfo;
    public static final CompoundName FIELD_FILLER_DISABLE = CompoundName.from((String)"FieldFiller.disable");

    public FieldFiller(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    @Override
    public Result search(Query query, Execution execution) {
        return execution.search(query);
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        execution.fill(result, summaryClass);
        Set<String> summaryFields = result.getQuery().getPresentation().getSummaryFields();
        if (summaryFields.isEmpty() || result.getQuery().properties().getBoolean(FIELD_FILLER_DISABLE)) {
            return;
        }
        String fromQuery = result.getQuery().getPresentation().getSummary();
        if (fromQuery == null) {
            return;
        }
        if (summaryClass == "[presentation]") {
            if (this.hasAll(summaryFields, fromQuery, result.getQuery().getModel().getRestrict())) {
                return;
            }
            execution.fill(result, fromQuery);
            return;
        }
        if (!summaryClass.equals(fromQuery)) {
            return;
        }
        if (this.hasAll(summaryFields, summaryClass, result.getQuery().getModel().getRestrict())) {
            return;
        }
        execution.fill(result, "default");
    }

    private boolean hasAll(Set<String> requested, String summaryName, Set<String> restrict) {
        HashSet<String> intersection = null;
        for (String schemaName : restrict.isEmpty() ? this.schemaInfo.schemas().keySet() : restrict) {
            Schema schema = this.schemaInfo.schemas().get(schemaName);
            if (schema == null) continue;
            DocumentSummary summary = schema.documentSummaries().get(summaryName);
            if (summary == null) {
                intersection = null;
                break;
            }
            if (intersection == null) {
                intersection = new HashSet<String>(summary.fields().size());
                intersection.addAll(summary.fields().keySet());
                continue;
            }
            intersection.retainAll(summary.fields().keySet());
        }
        return intersection != null && intersection.containsAll(requested);
    }
}

