/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.search.schema.FieldInfo;
import com.yahoo.tensor.TensorType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Field
implements FieldInfo {
    private final String name;
    private final Type type;
    private final boolean isAttribute;
    private final boolean isIndex;
    private final boolean bitPacked;
    private final Set<String> aliases;

    public Field(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.isAttribute = builder.isAttribute;
        this.isIndex = builder.isIndex;
        this.bitPacked = builder.isBitPacked;
        this.aliases = Set.copyOf(builder.aliases);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public Set<String> aliases() {
        return this.aliases;
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public boolean isIndex() {
        return this.isIndex;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.isAttribute != other.isAttribute) {
            return false;
        }
        if (this.isIndex != other.isIndex) {
            return false;
        }
        return this.aliases.equals(other.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.isAttribute, this.isIndex, this.aliases);
    }

    public String toString() {
        return "field '" + this.name + "'";
    }

    public static class Builder {
        private final String name;
        private final Type type;
        private final Set<String> aliases = new HashSet<String>();
        private boolean isAttribute;
        private boolean isIndex;
        private boolean isBitPacked;

        public Builder(String name, String typeString) {
            this.name = name;
            this.type = Type.from(typeString);
        }

        public Builder addAlias(String alias) {
            this.aliases.add(alias);
            return this;
        }

        public Builder setAttribute(boolean isAttribute) {
            this.isAttribute = isAttribute;
            return this;
        }

        public Builder setIndex(boolean isIndex) {
            this.isIndex = isIndex;
            return this;
        }

        public Builder setBitPacked(boolean isBitPacked) {
            this.isBitPacked = isBitPacked;
            return this;
        }

        public Field build() {
            return new Field(this);
        }
    }

    public static class Type {
        private final Kind kind;

        private Type(Kind kind) {
            this.kind = kind;
        }

        public Kind kind() {
            return this.kind;
        }

        public String toString() {
            return this.kind.toString();
        }

        public static Type from(String typeString) {
            if (typeString.startsWith("annotationreference<")) {
                return new Type(Kind.ANNOTATIONREFERENCE);
            }
            if (typeString.startsWith("array<")) {
                return new Type(Kind.ARRAY);
            }
            if (typeString.equals("bool")) {
                return new Type(Kind.BOOL);
            }
            if (typeString.equals("byte")) {
                return new Type(Kind.BYTE);
            }
            if (typeString.equals("double")) {
                return new Type(Kind.DOUBLE);
            }
            if (typeString.equals("float")) {
                return new Type(Kind.FLOAT);
            }
            if (typeString.equals("int")) {
                return new Type(Kind.INT);
            }
            if (typeString.equals("long")) {
                return new Type(Kind.LONG);
            }
            if (typeString.startsWith("map<")) {
                return new Type(Kind.MAP);
            }
            if (typeString.equals("position")) {
                return new Type(Kind.POSITION);
            }
            if (typeString.equals("predicate")) {
                return new Type(Kind.PREDICATE);
            }
            if (typeString.equals("raw")) {
                return new Type(Kind.RAW);
            }
            if (typeString.startsWith("reference<")) {
                return new Type(Kind.REFERENCE);
            }
            if (typeString.equals("string")) {
                return new Type(Kind.STRING);
            }
            if (typeString.startsWith("tensor<") || typeString.startsWith("tensor(")) {
                return new TensorFieldType(TensorType.fromSpec((String)typeString));
            }
            if (typeString.equals("url")) {
                return new Type(Kind.URL);
            }
            if (typeString.startsWith("weightedset<")) {
                return new Type(Kind.WEIGHTEDSET);
            }
            return new Type(Kind.STRUCT);
        }

        public static enum Kind {
            ANNOTATIONREFERENCE,
            ARRAY,
            BOOL,
            BYTE,
            DOUBLE,
            FLOAT,
            INT,
            LONG,
            MAP,
            POSITION,
            PREDICATE,
            RAW,
            REFERENCE,
            STRING,
            STRUCT,
            TENSOR,
            URL,
            WEIGHTEDSET;

        }
    }

    public static class TensorFieldType
    extends Type {
        private final TensorType tensorType;

        public TensorFieldType(TensorType tensorType) {
            super(Type.Kind.TENSOR);
            this.tensorType = tensorType;
        }

        public TensorType tensorType() {
            return this.tensorType;
        }

        @Override
        public String toString() {
            return this.tensorType.toString();
        }
    }
}

