/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.data.JsonProducer;
import com.yahoo.data.XmlProducer;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.JsonRender;
import java.util.Map;

public class PositionsData
implements Inspectable,
JsonProducer,
XmlProducer {
    private final Inspector value;

    public PositionsData(Inspector value) {
        this.value = value;
        if (value.type() != Type.OBJECT && value.type() != Type.ARRAY) {
            throw new IllegalArgumentException("PositionsData expects a position or an array of positions, got: " + String.valueOf(value));
        }
    }

    public Inspector inspect() {
        return this.value;
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public StringBuilder writeJson(StringBuilder target) {
        return JsonRender.render((Inspectable)this.value, (StringBuilder)target, (boolean)true);
    }

    @Override
    public StringBuilder writeXML(StringBuilder target) {
        if (this.value.type() == Type.OBJECT) {
            PositionsData.writeXML(this.value.inspect(), target);
        } else {
            for (int i = 0; i < this.value.entryCount(); ++i) {
                Inspector pos = this.value.entry(i);
                PositionsData.writeXML(pos, target);
            }
        }
        return target;
    }

    private static void writeXML(Inspector pos, StringBuilder target) {
        target.append("<position ");
        for (Map.Entry entry : pos.fields()) {
            Inspector v = (Inspector)entry.getValue();
            if (v.type() == Type.STRING) {
                target.append((String)entry.getKey());
                target.append("=\"");
                target.append(((Inspector)entry.getValue()).asString());
                target.append("\" ");
            }
            if (v.type() != Type.LONG) continue;
            target.append((String)entry.getKey());
            target.append("=\"");
            target.append(((Inspector)entry.getValue()).asLong());
            target.append("\" ");
        }
        target.append("/>");
    }
}

