/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.search.Query;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.Objects;

public class QueryType {
    private static final QueryProfileType argumentType = new QueryProfileType("type");
    private final Query.Type type;
    private Composite composite;
    private Tokenization tokenization;
    private Syntax syntax;
    private boolean isYqlDefault;
    public static final String COMPOSITE = "composite";
    public static final String TOKENIZATION = "tokenization";
    public static final String SYNTAX = "syntax";
    public static final String IS_YQL_DEFAULT = "isYqlDefault";

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public QueryType(Query.Type type, Composite composite, Tokenization tokenization, Syntax syntax) {
        this(type, composite, tokenization, syntax, false);
    }

    public QueryType(Query.Type type, Composite composite, Tokenization tokenization, Syntax syntax, boolean isYqlDefault) {
        this.type = type;
        this.composite = composite;
        this.tokenization = tokenization;
        this.syntax = syntax;
        this.isYqlDefault = isYqlDefault;
    }

    public Query.Type getType() {
        return this.type;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public QueryType setComposite(Composite composite) {
        this.composite = composite;
        return this;
    }

    public QueryType setComposite(String composite) {
        if (composite == null) {
            return this;
        }
        this.composite = Composite.valueOf(composite);
        return this;
    }

    public Tokenization getTokenization() {
        return this.tokenization;
    }

    public QueryType setTokenization(Tokenization tokenization) {
        this.tokenization = tokenization;
        return this;
    }

    public QueryType setTokenization(String tokenization) {
        if (tokenization == null) {
            return this;
        }
        this.tokenization = Tokenization.valueOf(tokenization);
        return this;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public QueryType setSyntax(Syntax syntax) {
        this.syntax = syntax;
        return this;
    }

    public QueryType setSyntax(String syntax) {
        if (syntax == null) {
            return this;
        }
        this.syntax = Syntax.valueOf(syntax);
        return this;
    }

    public boolean isYqlDefault() {
        return this.isYqlDefault;
    }

    public QueryType setYqlDefault(boolean isYqlDefault) {
        this.isYqlDefault = isYqlDefault;
        return this;
    }

    public void validate() {
        if (this.tokenization == Tokenization.linguistics && this.syntax != Syntax.none) {
            throw new IllegalArgumentException(String.valueOf(this) + " is invalid: Linguistics tokenization can only be combined with syntax none");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryType)) {
            return false;
        }
        QueryType other = (QueryType)o;
        if (other.type != this.type) {
            return false;
        }
        if (other.composite != this.composite) {
            return false;
        }
        if (other.tokenization != this.tokenization) {
            return false;
        }
        if (other.syntax != this.syntax) {
            return false;
        }
        return other.isYqlDefault == this.isYqlDefault;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.composite, this.tokenization, this.syntax, this.isYqlDefault});
    }

    public String toString() {
        return "query type " + String.valueOf((Object)this.type) + " [composite: " + String.valueOf((Object)this.composite) + ", tokenization: " + String.valueOf((Object)this.tokenization) + ", syntax: " + String.valueOf((Object)this.syntax) + "]";
    }

    public static QueryType from(Query.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Query.Type.ADVANCED -> new QueryType(type, Composite.and, Tokenization.internal, Syntax.advanced);
            case Query.Type.ALL -> new QueryType(type, Composite.and, Tokenization.internal, Syntax.simple);
            case Query.Type.ANY -> new QueryType(type, Composite.or, Tokenization.internal, Syntax.simple);
            case Query.Type.LINGUISTICS -> new QueryType(type, Composite.weakAnd, Tokenization.linguistics, Syntax.none);
            case Query.Type.PHRASE -> new QueryType(type, Composite.phrase, Tokenization.internal, Syntax.none);
            case Query.Type.PROGRAMMATIC -> new QueryType(type, Composite.and, Tokenization.internal, Syntax.programmatic);
            case Query.Type.SELECT -> new QueryType(type, Composite.and, Tokenization.internal, Syntax.json);
            case Query.Type.TOKENIZE -> new QueryType(type, Composite.weakAnd, Tokenization.internal, Syntax.none);
            case Query.Type.WEAKAND -> new QueryType(type, Composite.weakAnd, Tokenization.internal, Syntax.simple);
            case Query.Type.WEB -> new QueryType(type, Composite.and, Tokenization.internal, Syntax.web);
            case Query.Type.YQL -> new QueryType(type, Composite.and, Tokenization.internal, Syntax.yql);
        };
    }

    public static QueryType from(String typeName) {
        if (typeName == null) {
            return QueryType.from(Query.Type.WEAKAND);
        }
        return QueryType.from(Query.Type.getType(typeName));
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription("", "string"));
        argumentType.addField(new FieldDescription(COMPOSITE, "string"));
        argumentType.addField(new FieldDescription(TOKENIZATION, "string"));
        argumentType.addField(new FieldDescription(SYNTAX, "string"));
        argumentType.addField(new FieldDescription(IS_YQL_DEFAULT, "boolean"));
        argumentType.freeze();
    }

    public static enum Composite {
        and,
        or,
        phrase,
        weakAnd,
        near,
        oNear;

    }

    public static enum Tokenization {
        internal,
        linguistics;

    }

    public static enum Syntax {
        advanced,
        json,
        none,
        programmatic,
        simple,
        web,
        yql;

    }
}

