/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.DateFunction;
import com.yahoo.search.grouping.request.DayOfMonthFunction;
import com.yahoo.search.grouping.request.DayOfWeekFunction;
import com.yahoo.search.grouping.request.DayOfYearFunction;
import com.yahoo.search.grouping.request.FunctionNode;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.HourOfDayFunction;
import com.yahoo.search.grouping.request.MinuteOfHourFunction;
import com.yahoo.search.grouping.request.MonthOfYearFunction;
import com.yahoo.search.grouping.request.SecondOfMinuteFunction;
import com.yahoo.search.grouping.request.YearFunction;

public abstract class TimeFunctions {
    public static FunctionNode newInstance(Type type, GroupingExpression exp) {
        switch (type) {
            case DATE: {
                return TimeFunctions.newDate(exp);
            }
            case DAY_OF_MONTH: {
                return TimeFunctions.newDayOfMonth(exp);
            }
            case DAY_OF_WEEK: {
                return TimeFunctions.newDayOfWeek(exp);
            }
            case DAY_OF_YEAR: {
                return TimeFunctions.newDayOfYear(exp);
            }
            case HOUR_OF_DAY: {
                return TimeFunctions.newHourOfDay(exp);
            }
            case MINUTE_OF_HOUR: {
                return TimeFunctions.newMinuteOfHour(exp);
            }
            case MONTH_OF_YEAR: {
                return TimeFunctions.newMonthOfYear(exp);
            }
            case SECOND_OF_MINUTE: {
                return TimeFunctions.newSecondOfMinute(exp);
            }
            case YEAR: {
                return TimeFunctions.newYear(exp);
            }
        }
        throw new UnsupportedOperationException("Time function '" + String.valueOf((Object)type) + "' not supported.");
    }

    public static DateFunction newDate(GroupingExpression exp) {
        return new DateFunction(exp);
    }

    public static DayOfMonthFunction newDayOfMonth(GroupingExpression exp) {
        return new DayOfMonthFunction(exp);
    }

    public static DayOfWeekFunction newDayOfWeek(GroupingExpression exp) {
        return new DayOfWeekFunction(exp);
    }

    public static DayOfYearFunction newDayOfYear(GroupingExpression exp) {
        return new DayOfYearFunction(exp);
    }

    public static HourOfDayFunction newHourOfDay(GroupingExpression exp) {
        return new HourOfDayFunction(exp);
    }

    public static MinuteOfHourFunction newMinuteOfHour(GroupingExpression exp) {
        return new MinuteOfHourFunction(exp);
    }

    public static MonthOfYearFunction newMonthOfYear(GroupingExpression exp) {
        return new MonthOfYearFunction(exp);
    }

    public static SecondOfMinuteFunction newSecondOfMinute(GroupingExpression exp) {
        return new SecondOfMinuteFunction(exp);
    }

    public static YearFunction newYear(GroupingExpression exp) {
        return new YearFunction(exp);
    }

    public static enum Type {
        DATE,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        DAY_OF_YEAR,
        HOUR_OF_DAY,
        MINUTE_OF_HOUR,
        MONTH_OF_YEAR,
        SECOND_OF_MINUTE,
        YEAR;

    }
}

