/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.api.annotations.Beta;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.searchchain.Execution;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
@Provides(value={"SelectParameterParsing"})
public class GroupingQueryParser
extends Searcher {
    public static final String SELECT_PARAMETER_PARSING = "SelectParameterParsing";
    public static final CompoundName PARAM_CONTINUE = CompoundName.from((String)"continue");
    public static final CompoundName PARAM_REQUEST = CompoundName.from((String)"select");
    public static final CompoundName PARAM_TIMEZONE = CompoundName.from((String)"timezone");
    @Beta
    public static final CompoundName PARAM_DEFAULT_MAX_HITS = CompoundName.from((String)"grouping.defaultMaxHits");
    @Beta
    public static final CompoundName PARAM_DEFAULT_MAX_GROUPS = CompoundName.from((String)"grouping.defaultMaxGroups");
    @Beta
    public static final CompoundName PARAM_DEFAULT_PRECISION_FACTOR = CompoundName.from((String)"grouping.defaultPrecisionFactor");
    @Beta
    public static final CompoundName GROUPING_GLOBAL_MAX_GROUPS = CompoundName.from((String)"grouping.globalMaxGroups");
    private static final ThreadLocal<ZoneCache> zoneCache = new ThreadLocal();

    @Override
    public Result search(Query query, Execution execution) {
        try {
            GroupingQueryParser.validate(query);
            String reqParam = query.properties().getString(PARAM_REQUEST);
            if (reqParam == null) {
                return execution.search(query);
            }
            List<Continuation> continuations = this.getContinuations(query.properties().getString(PARAM_CONTINUE));
            for (GroupingOperation operation : GroupingOperation.fromStringAsList(reqParam)) {
                GroupingQueryParser.createGroupingRequestIn(query, operation, continuations);
            }
            return execution.search(query);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalInputException((Throwable)e);
        }
    }

    public static void validate(Query query) {
        if (query.getHttpRequest().getProperty(GROUPING_GLOBAL_MAX_GROUPS.toString()) != null) {
            throw new IllegalInputException(String.valueOf(GROUPING_GLOBAL_MAX_GROUPS) + " must be specified in a query profile.");
        }
    }

    public static void createGroupingRequestIn(Query query, GroupingOperation operation, List<Continuation> continuations) {
        GroupingRequest request = GroupingRequest.newInstance(query);
        request.setRootOperation(operation);
        request.setTimeZone(GroupingQueryParser.getTimeZone(query.properties().getString(PARAM_TIMEZONE, "utc")));
        request.continuations().addAll(continuations);
    }

    private List<Continuation> getContinuations(String param) {
        if (param == null) {
            return List.of();
        }
        LinkedList<Continuation> ret = new LinkedList<Continuation>();
        for (String str : param.split(" ")) {
            ret.add(Continuation.fromString(str));
        }
        return ret;
    }

    private static TimeZone getTimeZone(String name) {
        TimeZone timeZone;
        ZoneCache cache = zoneCache.get();
        if (cache == null) {
            cache = new ZoneCache();
            zoneCache.set(cache);
        }
        if ((timeZone = (TimeZone)cache.get(name)) == null) {
            timeZone = TimeZone.getTimeZone(name);
            cache.put(name, timeZone);
        }
        return timeZone;
    }

    private static class ZoneCache
    extends LinkedHashMap<String, TimeZone> {
        ZoneCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimeZone> entry) {
            return this.size() > 128;
        }
    }
}

