/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

public class Hasher<T> {
    private volatile NodeList<T> nodes = new NodeList(new NodeFactor[0]);

    public void add(T node) {
        this.add(node, 100);
    }

    public synchronized void add(T node, int load) {
        if (!this.nodes.hasNode(node)) {
            NodeFactor<T>[] oldNodes = this.nodes.nodes;
            NodeFactor[] newNodes = new NodeFactor[oldNodes.length + 1];
            System.arraycopy(oldNodes, 0, newNodes, 0, oldNodes.length);
            newNodes[newNodes.length - 1] = new NodeFactor<T>(node, load);
            this.nodes = new NodeList(newNodes);
        }
    }

    public synchronized void remove(T node) {
        if (this.nodes.hasNode(node)) {
            NodeFactor<T>[] oldNodes = this.nodes.nodes;
            NodeFactor[] newNodes = new NodeFactor[oldNodes.length - 1];
            int j = 0;
            for (int i = 0; i < oldNodes.length; ++i) {
                if (oldNodes[i].getNode() == node) continue;
                newNodes[j++] = oldNodes[i];
            }
            this.nodes = new NodeList(newNodes);
        }
    }

    public NodeList<T> getNodes() {
        return this.nodes;
    }

    public static class NodeList<T> {
        private final NodeFactor<T>[] nodes;
        private int totalLoadFactor;

        public NodeList(NodeFactor<T>[] nodes) {
            this.nodes = nodes;
            this.totalLoadFactor = 0;
            if (nodes != null) {
                for (NodeFactor<T> node : nodes) {
                    this.totalLoadFactor += node.getLoad();
                }
            }
        }

        public int getNodeCount() {
            return this.nodes.length;
        }

        public T select(int code, int trynum) {
            if (this.totalLoadFactor <= 0) {
                return null;
            }
            int hashValue = Math.abs(code * 76103) % this.totalLoadFactor;
            int sumLoad = 0;
            for (int targetNode = 0; targetNode < this.nodes.length && (sumLoad += this.nodes[targetNode].getLoad()) <= hashValue; ++targetNode) {
            }
            targetNode += trynum;
            return this.nodes[targetNode %= this.nodes.length].getNode();
        }

        public boolean hasNode(T node) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (node != this.nodes[i].getNode()) continue;
                return true;
            }
            return false;
        }
    }

    public static class NodeFactor<T> {
        private final T node;
        private final int load;

        public NodeFactor(T node, int load) {
            this.node = node;
            this.load = load;
        }

        public final T getNode() {
            return this.node;
        }

        public final int getLoad() {
            return this.load;
        }
    }
}

