/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.Schema;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import java.util.HashSet;
import java.util.Set;

@After(value={"ExternalYql"})
public class FieldFiller
extends Searcher {
    private final Set<String> intersectionOfAttributes;
    private final SchemaInfo schemaInfo;
    public static final CompoundName FIELD_FILLER_DISABLE = new CompoundName("FieldFiller.disable");

    public FieldFiller(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        this.intersectionOfAttributes = new HashSet<String>();
        boolean first = true;
        for (Schema schema : schemaInfo.schemas().values()) {
            for (DocumentSummary summary : schema.documentSummaries().values()) {
                if (!"attributeprefetch".equals(summary.name())) continue;
                HashSet<String> attributes = new HashSet<String>(summary.fields().size());
                for (DocumentSummary.Field f : summary.fields().values()) {
                    attributes.add(f.name());
                }
                if (first) {
                    first = false;
                    this.intersectionOfAttributes.addAll(attributes);
                    continue;
                }
                this.intersectionOfAttributes.retainAll(attributes);
            }
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        return execution.search(query);
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        Set<String> summaryFields = result.getQuery().getPresentation().getSummaryFields();
        if (summaryFields.isEmpty() || result.getQuery().properties().getBoolean(FIELD_FILLER_DISABLE)) {
            execution.fill(result, summaryClass);
            return;
        }
        if (summaryClass != null) {
            execution.fill(result, summaryClass);
            if (this.hasAll(summaryFields, summaryClass, result.getQuery().getModel().getRestrict())) {
                return;
            }
        }
        if (this.intersectionOfAttributes.containsAll(summaryFields)) {
            execution.fill(result, "attributeprefetch");
        } else {
            execution.fill(result, null);
        }
    }

    private boolean hasAll(Set<String> requested, String summaryName, Set<String> restrict) {
        HashSet<String> intersection = null;
        for (String schemaName : restrict.isEmpty() ? this.schemaInfo.schemas().keySet() : restrict) {
            Schema schema = this.schemaInfo.schemas().get(schemaName);
            if (schema == null) continue;
            DocumentSummary summary = schema.documentSummaries().get(summaryName);
            if (summary == null) {
                intersection = null;
                break;
            }
            if (intersection == null) {
                intersection = new HashSet<String>(summary.fields().size());
                intersection.addAll(summary.fields().keySet());
                continue;
            }
            intersection.retainAll(summary.fields().keySet());
        }
        return intersection != null && intersection.containsAll(requested);
    }
}

